(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', './Ripple', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('./Ripple'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.Ripple, global.babelHelpers);
        global.CenterRipple = mod.exports;
    }
})(this, function (exports, _san, _Ripple, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var _Ripple2 = babelHelpers.interopRequireDefault(_Ripple);

    exports.default = _san2.default.defineComponent({

        components: {
            'san-ripple': _Ripple2.default
        },

        template: '\n        <div\n            class="sm-center-ripple"\n            on-click="click($event)">\n            <san-ripple\n                san-for="ripple, index in ripples"\n                left="{{ripple.x}}"\n                top="{{ripple.y}}"\n                width="{{ripple.width}}"\n                height="{{ripple.height}}"\n                color="{{color}}"\n                on-animate-end="onRippleAnimateEnd(index)" />\n        </div>\n    ',

        initData: function initData() {
            return {
                ripples: []
            };
        },


        dataTypes: {
            color: _san.DataTypes.string
        },

        click: function click() {
            var _el$getBoundingClient = this.el.getBoundingClientRect(),
                width = _el$getBoundingClient.width,
                height = _el$getBoundingClient.height;

            this.data.push('ripples', {
                x: width / 2,
                y: height / 2,
                width: width,
                height: height
            });
        },
        onRippleAnimateEnd: function onRippleAnimateEnd(rippleIndex) {
            this.data.removeAt('ripples', rippleIndex);
        }
    });
});
//# sourceMappingURL=CenterRipple.js.map
