(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../common/util/cx', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../common/util/cx'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.cx, global.babelHelpers);
        global.FocusRipple = mod.exports;
    }
})(this, function (exports, _san, _cx, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var cx = (0, _cx.create)('focus-ripple');

    exports.default = _san2.default.defineComponent({

        template: '\n        <div class="{{styleClass}}">\n            <div class="' + cx.getPartClassName('circle') + '" style="{{circleStyle}}"></div>\n        </div>\n    ',

        computed: {
            circleStyle: function circleStyle() {
                return {
                    color: this.data.get('color'),
                    opacity: this.data.get('opacity')
                };
            },
            styleClass: function styleClass() {
                return cx(this).build();
            }
        },
        dataTypes: {
            color: _san.DataTypes.string,
            opacity: _san.DataTypes.string
        }
    });
});
//# sourceMappingURL=FocusRipple.js.map
