(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../common/util/cx', '../common/help', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../common/util/cx'), require('../common/help'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.cx, global.help, global.babelHelpers);
        global.Ripple = mod.exports;
    }
})(this, function (exports, _san, _cx, _help, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var cx = (0, _cx.create)('ripple');

    function getTimingValue(_ref, progress) {
        var _ref2 = babelHelpers.slicedToArray(_ref, 2),
            start = _ref2[0],
            stop = _ref2[1];

        return start + (stop - start) * progress;
    }

    exports.default = _san2.default.defineComponent({

        template: '\n        <div>\n            <div class="' + cx.getPartClassName() + '" style="{{style}}" s-transition="opacityTrans"></div>\n        <div>\n    ',

        initData: function initData() {
            return {
                step: 0,
                steps: 40,
                opacity: [0.1, 0],
                scale: [0, 2],
                animating: false,
                color: null
            };
        },
        opacityTrans: function opacityTrans() {
            var _this = this;

            return {
                enter: function enter(el, done) {
                    var opacity = _this.data.get('opacity');
                    var scale = _this.data.get('scale');
                    var step = _this.data.get('step');
                    var steps = _this.data.get('steps');
                    var top = _this.data.get('top');
                    var left = _this.data.get('left');
                    var width = _this.data.get('width');
                    var height = _this.data.get('height');
                    var color = _this.data.get('color');
                    var radius = Math.max(width, height);

                    el.style.top = top - radius + 'px';
                    el.style.left = left - radius + 'px';
                    el.style.width = radius * 2 + 'px';
                    el.style.height = radius * 2 + 'px';
                    el.style.backgroundColor = color;

                    var goStep = function goStep() {
                        if (step >= steps) {
                            _this.fire('animate-end');
                            done();
                            return;
                        }

                        var progress = step++ / steps;
                        var curOpacity = getTimingValue(opacity, progress);
                        var curScale = getTimingValue(scale, progress);
                        el.style.opacity = curOpacity;
                        el.style.transform = 'scale(' + curScale + ', ' + curScale + ')';
                        _this.requestAnimationId = (0, _help.requestAnimationFrame)(goStep);
                    };

                    _this.fire('animate-start');
                    goStep();
                }
            };
        },
        stopAnimation: function stopAnimation() {
            if (this.requestAnimationId) {
                (0, _help.cancelAnimationFrame)(this.requestAnimationId);
            }
        },
        detached: function detached() {
            this.stopAnimation();
        },
        disposed: function disposed() {
            this.requestAnimationId = null;
        }
    });
});
//# sourceMappingURL=Ripple.js.map
