(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', './Ripple', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('./Ripple'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.Ripple, global.babelHelpers);
        global.TouchRipple = mod.exports;
    }
})(this, function (exports, _san, _Ripple, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var _Ripple2 = babelHelpers.interopRequireDefault(_Ripple);

    exports.default = _san2.default.defineComponent({

        components: {
            'san-ripple': _Ripple2.default
        },

        template: '\n        <div\n            class="sm-touch-ripple"\n            on-click="click($event)">\n            <san-ripple\n                san-for="ripple, index in ripples"\n                left="{{ripple.x}}"\n                top="{{ripple.y}}"\n                width="{{ripple.width}}"\n                height="{{ripple.height}}"\n                color="{{color}}"\n                on-animate-end="onRippleAnimateEnd(index)" />\n        </div>\n    ',

        dataTypes: {
            color: _san.DataTypes.string
        },

        initData: function initData() {
            return {
                ripples: []
            };
        },
        click: function click(e) {
            var clientX = e.clientX,
                clientY = e.clientY;

            var _el$getBoundingClient = this.el.getBoundingClientRect(),
                top = _el$getBoundingClient.top,
                left = _el$getBoundingClient.left,
                width = _el$getBoundingClient.width,
                height = _el$getBoundingClient.height;

            this.data.push('ripples', {
                x: clientX - left,
                y: clientY - top,
                width: width,
                height: height
            });
        },
        onRippleAnimateEnd: function onRippleAnimateEnd(rippleIndex) {
            this.data.removeAt('ripples', rippleIndex);
        }
    });
});
//# sourceMappingURL=TouchRipple.js.map
