(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../Ripple/FocusRipple', '../common/util/cx', '../common/help', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../Ripple/FocusRipple'), require('../common/util/cx'), require('../common/help'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.FocusRipple, global.cx, global.help, global.babelHelpers);
        global.Slider = mod.exports;
    }
})(this, function (exports, _san, _FocusRipple, _cx, _help, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var _FocusRipple2 = babelHelpers.interopRequireDefault(_FocusRipple);

    var cx = (0, _cx.create)('slider');

    exports.default = _san2.default.defineComponent({
        template: '\n        <div class="{{styleClassName}}" tabindex="0"\n            on-focus="handleFocus($event)"\n            on-blur="handleBlur($event)"\n            on-touchstart="handleTouchStart($event)"\n            on-touchend="handleTouchEnd($event)"\n            on-touchcancel="handleTouchEnd($event)"\n            on-mousedown="handleMouseDown($event)"\n            on-mouseup="handleMouseUp($event)"\n            on-mouseenter="handleMouseEnter($event)"\n            on-mouseleave="handleMouseLeave($event)">\n            <input type="hidden" disabled="{{disabled ? \' disabled\' : \'\'}}" name="{{name}}" value="{{value}}">\n            <div class="' + cx.getPartClassName('bg') + '"></div>\n            <div class="' + cx.getPartClassName('fill') + '" style="{{fillStyle}}"></div>\n            <div class="' + cx.getPartClassName('thumb') + '"\n                style="{{thumbStyle}}"\n                title="\u503C\uFF1A{{value}}\uFF1B\u5360\u6BD4\uFF1A{{percent + \'%\'}}">\n                <san-focus-ripple san-if="{{showRipple}}"></san-focus-ripple>\n            </div>\n        </div>\n    ',

        components: {
            'san-focus-ripple': _FocusRipple2.default
        },

        initData: function initData() {
            return {
                max: 100,
                min: 0,
                step: 1,
                value: 0,
                dragRunning: false,
                dragging: false,
                active: 0,
                focus: 0,
                hover: 0 };
        },


        dataTypes: {
            max: _san.DataTypes.oneOfType([_san.DataTypes.number, _san.DataTypes.string]),
            min: _san.DataTypes.oneOfType([_san.DataTypes.number, _san.DataTypes.string]),
            step: _san.DataTypes.oneOfType([_san.DataTypes.number, _san.DataTypes.string]),
            value: _san.DataTypes.oneOfType([_san.DataTypes.number, _san.DataTypes.string]) },

        computed: {
            percent: function percent() {
                var min = this.data.get('min');
                var max = this.data.get('max');
                var value = this.data.get('value');
                var range = max - min;
                var percentNum = range > 0 ? (value - min) / range * 100 : 0;

                return percentNum > 100 ? 100 : percentNum < 0 ? 0 : percentNum;
            },
            styleClassName: function styleClassName() {
                return cx(this).build();
            },
            fillStyle: function fillStyle() {
                return {
                    width: this.data.get('percent') + '%'
                };
            },
            thumbStyle: function thumbStyle() {
                return {
                    left: this.data.get('percent') + '%'
                };
            },
            variants: function variants() {
                var result = [];
                if (this.data.get('value') <= this.data.get('min')) {
                    result.push('start');
                }

                if (this.data.get('active')) {
                    result.push('active');
                }

                return result;
            },
            showRipple: function showRipple() {
                var data = this.data;
                return (data.get('focus') || data.get('hover')) && !data.get('active');
            }
        },

        created: function created() {
            this.handleDragMouseMove = this.handleDragMouseMove.bind(this);
            this.handleMouseEnd = this.handleMouseEnd.bind(this);
            this.handleTouchMove = this.handleTouchMove.bind(this);
            this.handleTouchEnd = this.handleTouchEnd.bind(this);
        },
        getData: function getData() {
            var data = this.data;
            return {
                min: +data.get('min'),
                max: +data.get('max'),
                step: +data.get('step'),
                value: +data.get('value')
            };
        },
        setData: function setData(obj) {
            var data = this.data;

            for (var i in obj) {
                if (obj.hasOwnProperty(i)) {
                    data.set(i, obj[i]);
                }
            }
        },
        handleFocus: function handleFocus(e) {
            if (this.data.get('disabled')) {
                return;
            }
            this.data.set('focus', 1);
        },
        handleBlur: function handleBlur(e) {
            if (this.data.get('disabled')) {
                return;
            }
            this.data.set('focus', 0);
        },
        handleTouchStart: function handleTouchStart(e) {
            if (this.data.get('disabled')) {
                return;
            }
            this.setValue(e.touches[0]);

            var me = this;
            document.addEventListener('touchmove', me.handleTouchMove);
            document.addEventListener('touchup', me.handleTouchEnd);
            document.addEventListener('touchend', me.handleTouchEnd);
            document.addEventListener('touchcancel', me.handleTouchEnd);

            e.preventDefault();
            this.onDragStart(e);
        },
        handleTouchEnd: function handleTouchEnd(e) {
            if (this.data.get('disabled')) {
                return;
            }

            var me = this;
            document.removeEventListener('touchmove', me.handleTouchMove);
            document.removeEventListener('touchup', me.handleTouchEnd);
            document.removeEventListener('touchend', me.handleTouchEnd);
            document.removeEventListener('touchcancel', me.handleTouchEnd);

            this.onDragStop(e);
        },
        handleTouchMove: function handleTouchMove(e) {
            this.onDragUpdate(e.touches[0]);
        },
        handleMouseDown: function handleMouseDown(e) {
            if (this.data.get('disabled')) {
                return;
            }

            this.setValue(e);

            var me = this;
            document.addEventListener('mousemove', me.handleDragMouseMove);
            document.addEventListener('mouseup', me.handleMouseEnd);

            e.preventDefault();
            this.el.focus();
            this.onDragStart(e);
        },
        onDragStart: function onDragStart(e) {
            this.data.set('dragging', 1);
            this.data.set('active', 1);

            this.fire('dragStart', e);
        },
        onDragStop: function onDragStop(e) {
            this.data.set('dragging', 0);
            this.data.set('active', 0);

            this.fire('dragStop', e);
        },
        handleMouseEnd: function handleMouseEnd(e) {
            var me = this;
            document.removeEventListener('mousemove', me.handleDragMouseMove);
            document.removeEventListener('mouseup', me.handleMouseEnd);

            this.onDragStop(e);
        },
        handleDragMouseMove: function handleDragMouseMove(e) {
            this.onDragUpdate(e);
        },
        onDragUpdate: function onDragUpdate(e) {
            var data = this.data;
            if (data.get('dragRunning')) {
                return;
            }
            data.set('dragRunning', 1);

            var me = this;
            (0, _help.requestAnimationFrame)(function () {
                data.set('dragRunning', 0);
                if (!data.get('disable')) {
                    me.setValue(e);
                }
            });
        },
        handleMouseUp: function handleMouseUp(e) {
            if (this.data.get('disabled')) {
                return;
            }

            this.data.set('active', 0);
        },
        handleMouseEnter: function handleMouseEnter(e) {
            if (this.data.get('disabled')) {
                return;
            }

            this.data.set('hover', 1);
        },
        handleMouseLeave: function handleMouseLeave(e) {
            if (this.data.get('disabled')) {
                return;
            }

            this.data.set('hover', 0);
        },
        setValue: function setValue(e) {
            var _getData = this.getData(),
                max = _getData.max,
                min = _getData.min,
                value = _getData.value,
                step = _getData.step;

            var oldValue = value;
            var elLeft = this.el.getBoundingClientRect().left;
            var elWidth = this.el.offsetWidth;
            var range = max - min;

            value = elWidth && (e.clientX - elLeft) / elWidth * range;
            value = Math.round(value / step) * step + min;
            value = parseFloat(value.toFixed(5));

            if (value > max) {
                value = max;
            } else if (value < min) {
                value = min;
            }

            if (value !== oldValue) {
                this.setData({ value: value });
                this.fire('change', value);
            }
        }
    });
});
//# sourceMappingURL=Slider.js.map
