(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../Ripple/index', 'classnames', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../Ripple/index'), require('classnames'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.index, global.classnames, global.babelHelpers);
        global.Switch = mod.exports;
    }
})(this, function (exports, _san, _index, _classnames, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var _classnames2 = babelHelpers.interopRequireDefault(_classnames);

    exports.default = _san2.default.defineComponent({
        template: '\n        <label\n            class="{{mainClass}}"\n            on-click="handleClick">\n            <input type="checkbox"\n                disabled="{{disabled}}"\n                value="ON"\n                on-change="handleChange($event)"\n                checked="{= inputValue =}">\n            <div class="sm-switch-wrapper">\n                <div class="sm-switch-label {{labelClass}}" san-if="label && labelLeft">{{label}}</div>\n                <div class="sm-switch-container">\n                    <div class="sm-switch-track {{trackClass}}"></div>\n                    <div class="sm-switch-thumb {{thumbClass}}">\n                        <sm-center-ripple class="sm-switch-ripple-wrapper" san-ref="ripple"></sm-center-ripple>\n                    </div>\n                </div>\n                <div class="sm-switch-label {{labelClass}}" san-if="label && !labelLeft">{{label}}</div>\n            </div>\n        </label>\n\n    ',
        initData: function initData() {
            return {
                name: '',
                onValue: 'ON',
                offValue: 'OFF',
                value: 'OFF',
                label: '',
                labelLeft: false,
                labelClass: '',
                trackClass: '',
                thumbClass: '',
                disabled: false,
                inputValue: []
            };
        },


        dataTypes: {
            name: _san.DataTypes.string,
            onValue: _san.DataTypes.oneOfType([_san.DataTypes.string, _san.DataTypes.bool]),
            offValue: _san.DataTypes.oneOfType([_san.DataTypes.string, _san.DataTypes.bool]),
            value: _san.DataTypes.oneOfType([_san.DataTypes.string, _san.DataTypes.bool]),
            label: _san.DataTypes.string,
            labelLeft: _san.DataTypes.bool,
            labelClass: _san.DataTypes.string,
            trackClass: _san.DataTypes.string,
            thumbClass: _san.DataTypes.string,
            disabled: _san.DataTypes.bool,
            inputValue: _san.DataTypes.arrayOf(_san.DataTypes.string)
        },

        components: {
            'sm-center-ripple': _index.CenterRipple
        },

        computed: {
            mainClass: function mainClass() {
                return (0, _classnames2.default)('sm-switch', {
                    'label-left': this.data.get('labelLeft'),
                    'disabled': this.data.get('disabled'),
                    'no-label': !this.data.get('label')
                });
            }
        },

        dealInput: function dealInput() {
            var _data$get = this.data.get(),
                value = _data$get.value,
                inputValue = _data$get.inputValue,
                onValue = _data$get.onValue,
                offValue = _data$get.offValue;

            if (value === onValue && !inputValue[0]) {
                this.data.set('inputValue[0]', 'ON');
            }

            if (value === offValue && inputValue[0]) {
                this.data.set('inputValue', []);
            }
        },
        checkInputDataType: function checkInputDataType() {
            var _data$get2 = this.data.get(),
                onValue = _data$get2.onValue,
                offValue = _data$get2.offValue,
                value = _data$get2.value;

            this.currentDataType = typeof onValue === 'undefined' ? 'undefined' : babelHelpers.typeof(onValue);
            if (this.currentDataType !== (typeof offValue === 'undefined' ? 'undefined' : babelHelpers.typeof(offValue)) || this.currentDataType !== (typeof value === 'undefined' ? 'undefined' : babelHelpers.typeof(value))) {
                throw new Error('[SAN-MUI ERROR] the data type of ("onValue", "offValue", "value") ' + ' must be all the same in SWITCH component. ');
            }
        },
        attached: function attached() {
            var _this = this;

            this.checkInputDataType();
            this.dealInput();

            this.watch('value', function (val) {
                _this.fire('input-change', val);
                _this.checkInputDataType();
                _this.dealInput();
            });
            this.watch('inputValue', function (val) {
                var onValue = _this.data.get('onValue');
                var offValue = _this.data.get('offValue');
                if (val && val[0]) {
                    _this.data.set('value', onValue);
                    return;
                }
                _this.data.set('value', offValue);
            });
        },
        handleClick: function handleClick(e) {
            if (this.data.get('disabled')) {
                return;
            }

            if (e.target.tagName === 'INPUT') {
                return;
            }
            this.ref('ripple').click();
        },
        handleChange: function handleChange(e) {
            this.fire('change', e);
        },
        handleMouseUp: function handleMouseUp() {},
        handleMouseLeave: function handleMouseLeave() {},
        handleTouchStart: function handleTouchStart(event) {},
        handleTouchEnd: function handleTouchEnd() {}
    });
});
//# sourceMappingURL=Switch.js.map
