(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', './Table', './THead', './TBody', './TR', './TD', './TH', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('./Table'), require('./THead'), require('./TBody'), require('./TR'), require('./TD'), require('./TH'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.Table, global.THead, global.TBody, global.TR, global.TD, global.TH, global.babelHelpers);
        global.ConfigurableTable = mod.exports;
    }
})(this, function (exports, _san, _Table2, _THead, _TBody, _TR, _TD, _TH, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _Table3 = babelHelpers.interopRequireDefault(_Table2);

    var _THead2 = babelHelpers.interopRequireDefault(_THead);

    var _TBody2 = babelHelpers.interopRequireDefault(_TBody);

    var _TR2 = babelHelpers.interopRequireDefault(_TR);

    var _TD2 = babelHelpers.interopRequireDefault(_TD);

    var _TH2 = babelHelpers.interopRequireDefault(_TH);

    var ConfigurableTable = function (_Table) {
        babelHelpers.inherits(ConfigurableTable, _Table);

        function ConfigurableTable() {
            babelHelpers.classCallCheck(this, ConfigurableTable);
            return babelHelpers.possibleConstructorReturn(this, (ConfigurableTable.__proto__ || Object.getPrototypeOf(ConfigurableTable)).apply(this, arguments));
        }

        return ConfigurableTable;
    }(_Table3.default);

    ConfigurableTable.components = {
        'ui-tr': _TR2.default,
        'ui-th': _TH2.default,
        'ui-td': _TD2.default,
        'ui-tbody': _TBody2.default,
        'ui-thead': _THead2.default
    };
    ConfigurableTable.messages = _Table3.default.messages;
    ConfigurableTable.filters = {
        renderField: function renderField(field, item) {
            if (typeof field.content === 'function') {
                return field.content.call(this, item);
            } else if (field.prop) {
                return item[field.prop];
            }

            return '';
        }
    };
    ConfigurableTable.template = '\n        <table class="{{className}}">\n            <ui-thead>\n                <ui-tr>\n                    <ui-td san-for="field in fields">{{field.title}}</ui-td>\n                </ui-tr>\n            </ui-thead>\n            <ui-tbody>\n                <ui-tr san-for="item in data" selected="{=item.selected=}" disabled="{{item.disabled}}">\n                    <ui-td san-for="field in fields">{{field | renderField(item)}}</ui-td>\n                </ui-tr>\n            </ui-tbody>\n        </table>\n    ';
    ConfigurableTable.dataTypes = babelHelpers.extends({}, _Table3.default.dataTypes, {
        fields: _san.DataTypes.arrayOf(_san.DataTypes.shape({
            prop: _san.DataTypes.string,
            title: _san.DataTypes.string,
            content: _san.DataTypes.func
        })),
        data: _san.DataTypes.array
    });
    exports.default = ConfigurableTable;
});
//# sourceMappingURL=ConfigurableTable.js.map
