(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', './TR', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('./TR'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.TR, global.babelHelpers);
        global.TBody = mod.exports;
    }
})(this, function (exports, _san, _TR, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var _TR2 = babelHelpers.interopRequireDefault(_TR);

    var TBody = function (_san$Component) {
        babelHelpers.inherits(TBody, _san$Component);

        function TBody() {
            babelHelpers.classCallCheck(this, TBody);
            return babelHelpers.possibleConstructorReturn(this, (TBody.__proto__ || Object.getPrototypeOf(TBody)).apply(this, arguments));
        }

        babelHelpers.createClass(TBody, [{
            key: 'inited',
            value: function inited() {
                this.dispatch('UI:tbody-inited');
            }
        }, {
            key: 'eachItem',
            value: function eachItem(iterator) {
                var _this2 = this;

                this.findChildrenTRs().forEach(function (child, index) {
                    iterator.call(_this2, child, index);
                    index++;
                });
            }
        }, {
            key: 'findChildrenTRs',
            value: function findChildrenTRs() {
                var result = [];

                function find(node) {
                    if (node instanceof _TR2.default) {
                        result.push(node);
                    } else if (node.children) {
                        node.children.forEach(function (child) {
                            find(child);
                        });
                    }
                }

                find(this);

                return result;
            }
        }]);
        return TBody;
    }(_san2.default.Component);

    TBody.template = '\n        <tbody>\n            <slot></slot>\n        </tbody>\n    ';
    TBody.messages = {
        'UI:tr-inited': function UITrInited(e) {
            var tr = e.target;
            tr.data.set('pos', 'tbody');
            tr.data.set('tableSelectable', this.data.get('tableSelectable'));
        },
        'UI:table-select-item': function UITableSelectItem(e) {
            var selectable = this.data.get('tableSelectable');
            var selected = void 0;

            switch (selectable) {
                case 'single':
                    this.eachItem(function (tr, index) {
                        var isSelected = tr === e.target;

                        tr.data.set('selected', isSelected);
                        if (isSelected) {
                            selected = index;
                        }
                    });
                    break;
                case 'multi':
                    selected = [];
                    this.eachItem(function (tr, index) {
                        if (tr.data.get('selected')) {
                            selected.push(index);
                        }
                    });
                    break;
            }

            this.dispatch('UI:table-select-body', selected);
        }
    };
    exports.default = TBody;
});
//# sourceMappingURL=TBody.js.map
