(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.babelHelpers);
        global.THead = mod.exports;
    }
})(this, function (exports, _san, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var THead = function (_san$Component) {
        babelHelpers.inherits(THead, _san$Component);

        function THead() {
            babelHelpers.classCallCheck(this, THead);
            return babelHelpers.possibleConstructorReturn(this, (THead.__proto__ || Object.getPrototypeOf(THead)).apply(this, arguments));
        }

        babelHelpers.createClass(THead, [{
            key: 'inited',
            value: function inited() {
                this.dispatch('UI:thead-inited');
            }
        }, {
            key: 'disposed',
            value: function disposed() {
                this.tr = null;
            }
        }, {
            key: 'updateSelectedState',
            value: function updateSelectedState(type) {
                if (!this.tr) {
                    return;
                }
                switch (type) {
                    case 'all':
                        this.tr.data.set('selected', true);
                        this.tr.data.set('indeterminate', false);
                        break;
                    case 'indeterminate':
                        this.tr.data.set('selected', false);
                        this.tr.data.set('indeterminate', true);
                        break;
                    case 'none':
                        this.tr.data.set('selected', false);
                        this.tr.data.set('indeterminate', false);
                        break;
                }
            }
        }]);
        return THead;
    }(_san2.default.Component);

    THead.template = '\n        <thead><slot></slot></thead>\n    ';
    THead.messages = {
        'UI:tr-inited': function UITrInited(e) {
            var tr = e.target;
            tr.data.set('pos', 'thead');
            tr.data.set('tableSelectable', this.data.get('tableSelectable'));
            this.tr = tr;
        }
    };
    exports.default = THead;
});
//# sourceMappingURL=THead.js.map
