(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', './TD', './TH', '../Checkbox/index', '../Radio/index', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('./TD'), require('./TH'), require('../Checkbox/index'), require('../Radio/index'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.TD, global.TH, global.index, global.index, global.babelHelpers);
        global.TR = mod.exports;
    }
})(this, function (exports, _san, _TD, _TH, _index, _index3, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var _TD2 = babelHelpers.interopRequireDefault(_TD);

    var _TH2 = babelHelpers.interopRequireDefault(_TH);

    var _index2 = babelHelpers.interopRequireDefault(_index);

    var _index4 = babelHelpers.interopRequireDefault(_index3);

    var TR = function (_san$Component) {
        babelHelpers.inherits(TR, _san$Component);

        function TR() {
            babelHelpers.classCallCheck(this, TR);
            return babelHelpers.possibleConstructorReturn(this, (TR.__proto__ || Object.getPrototypeOf(TR)).apply(this, arguments));
        }

        babelHelpers.createClass(TR, [{
            key: 'initData',
            value: function initData() {
                return {
                    pos: 'tbody',
                    selected: false,
                    indeterminate: false,
                    disable: false
                };
            }
        }, {
            key: 'inited',
            value: function inited() {
                this.dispatch('UI:tr-inited');
            }
        }, {
            key: 'attached',
            value: function attached() {
                this.dispatch('UI:tr-attached');
            }
        }, {
            key: 'select',
            value: function select(checked) {
                var _data$get = this.data.get(),
                    selected = _data$get.selected,
                    pos = _data$get.pos;

                var nextSelected = !!checked.length;

                if (selected === nextSelected) {
                    return;
                }

                this.data.set('selected', nextSelected);

                this.dispatch('UI:table-select-' + (pos === 'tbody' ? 'item' : 'head'), nextSelected);
            }
        }, {
            key: 'detached',
            value: function detached() {
                this.dispatch('UI:tr-detached');
            }
        }]);
        return TR;
    }(_san2.default.Component);

    TR.components = {
        'sm-td': _TD2.default,
        'sm-th': _TH2.default,
        'sm-checkbox': _index2.default,
        'sm-radio': _index4.default
    };
    TR.template = '\n        <tr class="{{selected && pos === \'tbody\' ? \'sm-table-row-selected\' : \'\'}}">\n            <sm-th\n                san-if="tableSelectable === \'multi\'"\n                class="sm-table-col-select">\n                <sm-checkbox\n                    s-ref="checkbox"\n                    checked="{{checked}}"\n                    indeterminate="{{indeterminate}}"\n                    value="ON"\n                    disabled="{{!!disabled}}"\n                    on-input-change="select($event)"/>\n            </sm-th>\n            <sm-th\n                san-if="tableSelectable === \'single\'"\n                class="sm-table-col-select">\n                <sm-radio\n                    s-if="tableSelectable && pos === \'tbody\'"\n                    checked="{{checked}}"\n                    value="ON"\n                    on-input-change="select($event)" />\n            </sm-th>\n            <slot></slot>\n        </tr>\n    ';
    TR.computed = {
        checked: function checked() {
            var selected = this.data.get('selected');
            var tableSelectable = this.data.get('tableSelectable');
            switch (tableSelectable) {
                case 'single':
                    return selected ? 'ON' : '';
                case 'multi':
                    return selected ? ['ON'] : [];
            }
        }
    };
    TR.dataTypes = {
        pos: _san.DataTypes.oneOf(['tbody', 'thead', 'tfoot']),
        selected: _san.DataTypes.bool,
        indeterminate: _san.DataTypes.bool
    };
    exports.default = TR;
});
//# sourceMappingURL=TR.js.map
