(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../common/util/cx', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../common/util/cx'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.cx, global.babelHelpers);
        global.Table = mod.exports;
    }
})(this, function (exports, _san, _cx, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var cx = (0, _cx.create)('table');

    var Table = function (_san$Component) {
        babelHelpers.inherits(Table, _san$Component);

        function Table() {
            babelHelpers.classCallCheck(this, Table);
            return babelHelpers.possibleConstructorReturn(this, (Table.__proto__ || Object.getPrototypeOf(Table)).apply(this, arguments));
        }

        babelHelpers.createClass(Table, [{
            key: 'initData',
            value: function initData() {
                return {
                    selectable: false,
                    data: []
                };
            }
        }, {
            key: 'attached',
            value: function attached() {
                var _this2 = this;

                var _data$get = this.data.get(),
                    selectable = _data$get.selectable,
                    data = _data$get.data;

                if (!selectable) {
                    return;
                }

                if (this.thead && data) {
                    var type = this.checkTHeadState(data);
                    this.thead.updateSelectedState(type);
                }

                this.watch('data', function (val) {
                    var type = _this2.checkTHeadState(val);
                    _this2.thead.updateSelectedState(type);
                });
            }
        }, {
            key: 'checkTHeadState',
            value: function checkTHeadState(val) {
                var total = val.filter(function (item) {
                    return !item.disabled;
                });
                var selected = val.filter(function (item) {
                    return !item.disabled && item.selected;
                });
                var type = void 0;
                if (selected.length === 0) {
                    type = 'none';
                } else if (selected.length === total.length) {
                    type = 'all';
                } else {
                    type = 'indeterminate';
                }

                return type;
            }
        }, {
            key: 'disposed',
            value: function disposed() {
                this.tbody = this.thead = this.tfoot = null;
            }
        }]);
        return Table;
    }(_san2.default.Component);

    Table.template = '\n        <table class="{{className}}">\n            <slot name="header"></slot>\n            <slot></slot>\n            <slot name="footer"></slot>\n        </table>\n    ';
    Table.messages = {
        'UI:tbody-inited': function UITbodyInited(e) {
            this.tbody = e.target;
            e.target.data.set('tableSelectable', this.data.get('selectable'));
        },
        'UI:thead-inited': function UITheadInited(e) {
            this.thead = e.target;
            e.target.data.set('tableSelectable', this.data.get('selectable'));
        },
        'UI:table-select-head': function UITableSelectHead(e) {
            var selected = [];
            var selectAll = e.value;
            this.tbody.eachItem(function (tr, index) {
                var trDisabled = tr.data.get('disabled');
                if (!trDisabled) {
                    tr.data.set('selected', selectAll);
                    if (selectAll) {
                        selected.push(index);
                    }
                } else {
                    var trSelected = tr.data.get('selected');
                    if (trSelected) {
                        selected.push(index);
                    }
                }
            });

            this.fire('select', selected);
        },
        'UI:table-select-body': function UITableSelectBody(e) {
            this.fire('select', e.value);
        }
    };
    Table.computed = {
        className: function className() {
            return cx(this).build();
        }
    };
    Table.dataTypes = {
        data: _san.DataTypes.array,
        selectable: _san.DataTypes.oneOf([false, 'multi', 'single'])
    };
    exports.default = Table;
});
//# sourceMappingURL=Table.js.map
