(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../Ripple/index', '../common/util/cx', './constant', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../Ripple/index'), require('../common/util/cx'), require('./constant'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.index, global.cx, global.constant, global.babelHelpers);
        global.Tab = mod.exports;
    }
})(this, function (exports, _san, _index, _cx, _constant, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var cx = (0, _cx.create)('tab');

    exports.default = _san2.default.defineComponent({

        components: {
            'san-touch-ripple': _index.TouchRipple
        },

        template: '\n        <div class="{{computedClassName}}" on-click="click">\n            <slot name="icon" />\n            <slot name="label" />\n            <san-touch-ripple />\n        </div>\n    ',

        computed: {
            computedClassName: function computedClassName() {
                var active = this.data.get('active');
                return cx(this).addStates({ active: active }).build();
            }
        },

        dataTypes: {
            value: _san.DataTypes.string.isRequired
        },

        inited: function inited() {
            this.dispatch(_constant.TAB_INIT);
        },
        click: function click() {
            if (!this.data.get('active')) {
                this.dispatch(_constant.TAB_ACTIVE);
            }
        },
        detached: function detached() {
            this.dispatch(_constant.TAB_DISPOSE);
        }
    });
});
//# sourceMappingURL=Tab.js.map
