(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../common/util/css', './constant', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../common/util/css'), require('./constant'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.css, global.constant, global.babelHelpers);
        global.Tabs = mod.exports;
    }
})(this, function (exports, _san, _css, _constant, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var _css2 = babelHelpers.interopRequireDefault(_css);

    var _messages;

    exports.default = _san2.default.defineComponent({

        template: '\n        <div class="sm-tabs">\n            <slot />\n            <div class="sm-tabs-bar" style="{{barStyle}}"/>\n        </div>\n    ',

        initData: function initData() {
            return {
                items: []
            };
        },
        inited: function inited() {
            var _this = this;

            this.items = [];

            this.watch('value', function (value) {
                return _this.setActiveTab(value);
            });
        },
        attached: function attached() {
            this.setActiveTab(this.data.get('value'));
        },
        disposed: function disposed() {
            this.items.length = 0;
            this.items = null;
        },
        addItem: function addItem(itemComponent) {
            this.items.push(itemComponent);
            this.data.push('items', itemComponent.data.get('value'));
        },
        removeItem: function removeItem(itemComponent) {
            this.items = this.items.filter(function (item) {
                return item !== itemComponent;
            });
            if (this.data) {
                this.data.remove('items', itemComponent.data.get('value'));
            }
        },


        computed: {
            barStyle: function barStyle() {

                var items = this.data.get('items');
                var value = this.data.get('value');
                var total = items.length;
                var activeIndex = items.findIndex(function (item) {
                    return item === value;
                });

                if (activeIndex < 0) {
                    activeIndex = 0;
                }

                return (0, _css2.default)({
                    transform: 'translateX(' + activeIndex * 100 + '%)',
                    width: 1 / total * 100 + '%'
                });
            }
        },

        dataTypes: {
            value: _san.DataTypes.string
        },

        setActiveTab: function setActiveTab(value) {
            this.items.forEach(function (item) {
                item.data.set('active', item.data.get('value') === value);
            });
        },


        messages: (_messages = {}, babelHelpers.defineProperty(_messages, _constant.TAB_INIT, function (_ref) {
            var target = _ref.target;

            this.addItem(target);
        }), babelHelpers.defineProperty(_messages, _constant.TAB_ACTIVE, function (_ref2) {
            var target = _ref2.target;

            var currentValue = target.data.get('value');
            this.data.set('value', currentValue);
            this.fire('change', currentValue);
        }), babelHelpers.defineProperty(_messages, _constant.TAB_DISPOSE, function (_ref3) {
            var target = _ref3.target;

            this.removeItem(target);
        }), _messages)

    });
});
//# sourceMappingURL=Tabs.js.map
