(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', './TextFieldUnderline', './TextFieldLabel', './TextFieldHint', './TextFieldEnhancedTextarea', '../Icon/index', 'classnames', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('./TextFieldUnderline'), require('./TextFieldLabel'), require('./TextFieldHint'), require('./TextFieldEnhancedTextarea'), require('../Icon/index'), require('classnames'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.TextFieldUnderline, global.TextFieldLabel, global.TextFieldHint, global.TextFieldEnhancedTextarea, global.index, global.classnames, global.babelHelpers);
        global.TextField = mod.exports;
    }
})(this, function (exports, _san, _TextFieldUnderline, _TextFieldLabel, _TextFieldHint, _TextFieldEnhancedTextarea, _index, _classnames, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var _TextFieldUnderline2 = babelHelpers.interopRequireDefault(_TextFieldUnderline);

    var _TextFieldLabel2 = babelHelpers.interopRequireDefault(_TextFieldLabel);

    var _TextFieldHint2 = babelHelpers.interopRequireDefault(_TextFieldHint);

    var _TextFieldEnhancedTextarea2 = babelHelpers.interopRequireDefault(_TextFieldEnhancedTextarea);

    var _index2 = babelHelpers.interopRequireDefault(_index);

    var _classnames2 = babelHelpers.interopRequireDefault(_classnames);

    exports.default = _san2.default.defineComponent({
        template: '\n<div class="{{computedClass}}"\n    style="{{errorColor ? \'color:\' + errorColor : \'\'}}">\n    <sm-icon san-if="{{icon}}" class="sm-text-field-icon">{{icon}}</sm-icon>\n    <div class="sm-text-field-content">\n        <text-field-label\n            san-if="{{label}}"\n            float="{{getFloatValue}}"\n            focus="{{focus}}"\n            normalClass="{{labelClass}}"\n            focusClass="{{labelFocusClass}}">\n            <span>{{label}}</span>\n        </text-field-label>\n        <text-field-hint\n            san-if="{{hintText}}"\n            text="{{hintText}}"\n            hintTextClass="{{hintTextClass}}"\n            show="{{isHintShow}}">\n        </text-field-hint>\n            <slot>\n                <input\n                    san-if="!multiLine"\n                    type="{{type}}"\n                    value="{{inputValue}}"\n                    disabled="{{disabled}}"\n                    readonly="{{readOnly}}"\n                    on-focus="handleFocus($event)"\n                    on-input="handleChange($event)"\n                    on-blur="handleBlur($event)"\n                    on-keyup="handleKeyup($event)"\n                    on-keypress="handleKeypress($event)"\n                    on-keydown="handleKeydown($event)"\n                    class="sm-text-field-input {{inputClass}}"/>\n                <enhanced-textarea\n                    san-if="multiLine"\n                    normalClass="{{inputClass}}"\n                    value="{= inputValue =}"\n                    disabled="{{disabled}}"\n                    readOnly="{{readOnly}}"\n                    rows="{{rows}}"\n                    rowsMax="{{rowsMax}}"\n                    on-input="handleChange($event)"\n                    on-focus="handleFocus($event)"\n                    on-blur="handleBlur($event)"\n                    on-keyup="handleKeyup($event)"\n                    on-keypress="handleKeypress($event)"\n                    on-keydown="handleKeydown($event)"></enhanced-textarea>\n            </slot>\n        <underline\n            san-if="underlineShow"\n            error="{{!!errorText}}"\n            disabled="{{disabled}}"\n            errorColor="{{errorColor}}"\n            focus="{{focus}}"\n            normalClass="{{underlineClass}}"\n            focusClass="{{underlineFocusClass}}">\n        </underline>\n        <div\n            class="{{ComputedhelpTextClass}}"\n            style="{{errorColor ? (\'color:\' + errorColor) : \'\'}}"\n            san-if="errorText || helpText || maxLength > 0">\n            <div>\n                {{errorText || helpText}}\n            </div>\n            <div san-if="maxLength > 0">\n                {{charLength}}/{{maxLength}}\n            </div>\n        </div>\n    </div>\n</div>\n',

        initData: function initData() {
            return {
                type: 'text',
                label: '',
                labelFloat: false,
                labelClass: '',
                labelFocusClass: '',
                hintText: '',
                hintTextClass: '',
                inputClass: '',
                errorText: '',
                errorColor: '',
                helpText: '',
                helpTextClass: '',
                maxLength: 0,
                disabled: false,
                readOnly: false,
                fullWidth: false,
                underlineShow: true,
                underlineClass: '',
                underlineFocusClass: '',
                focus: false,
                inputValue: '',
                charLength: 0,
                multiLine: false,
                icon: ''
            };
        },


        dataTypes: {
            type: _san.DataTypes.string,
            label: _san.DataTypes.string,
            labelFloat: _san.DataTypes.bool,
            labelClass: _san.DataTypes.string,
            labelFocusClass: _san.DataTypes.string,
            hintText: _san.DataTypes.string,
            hintTextClass: _san.DataTypes.string,
            inputClass: _san.DataTypes.string,
            errorText: _san.DataTypes.string,
            errorColor: _san.DataTypes.string,
            helpText: _san.DataTypes.string,
            helpTextClass: _san.DataTypes.string,
            maxLength: _san.DataTypes.number,
            disabled: _san.DataTypes.bool,
            readOnly: _san.DataTypes.bool,
            fullWidth: _san.DataTypes.bool,
            underlineShow: _san.DataTypes.bool,
            underlineClass: _san.DataTypes.string,
            underlineFocusClass: _san.DataTypes.string,
            focus: _san.DataTypes.bool,
            inputValue: _san.DataTypes.oneOfType([_san.DataTypes.string, _san.DataTypes.number]),
            charLength: _san.DataTypes.number,
            multiLine: _san.DataTypes.bool,
            icon: _san.DataTypes.string
        },

        computed: {
            computedClass: function computedClass() {
                var focus = this.data.get('focus');
                var label = this.data.get('label');
                var errorText = this.data.get('errorText');
                var disabled = this.data.get('disabled');
                var fullWidth = this.data.get('fullWidth');
                var multiLine = this.data.get('multiLine');
                var icon = this.data.get('icon');
                return (0, _classnames2.default)('sm-text-field', focus ? 'focus-state' : '', label ? 'has-label' : '', errorText ? 'error' : '', disabled ? 'disabled' : '', fullWidth ? 'full-width' : '', multiLine ? 'multi-line' : '', icon ? 'has-icon' : '');
            },
            isHintShow: function isHintShow() {
                var focus = this.data.get('focus');
                var inputValue = this.data.get('inputValue');
                var labelFloat = this.data.get('labelFloat');
                if ((!labelFloat || focus) && !inputValue && inputValue !== 0) {
                    return true;
                }
                return false;
            },
            getFloatValue: function getFloatValue() {
                var focus = this.data.get('focus');
                var inputValue = this.data.get('inputValue');
                var labelFloat = this.data.get('labelFloat');
                if (labelFloat && !focus && !inputValue && inputValue !== 0) {
                    return true;
                }
                return false;
            },
            ComputedhelpTextClass: function ComputedhelpTextClass() {
                var helpTextClass = this.data.get('helpTextClass');
                return (0, _classnames2.default)('sm-text-field-help', helpTextClass ? helpTextClass : '');
            }
        },

        inited: function inited() {
            var inputValue = this.data.get('inputValue');
            this.calcCharLength(inputValue);
        },
        attached: function attached() {
            var _this = this;

            this.watch('inputValue', function (val) {
                _this.calcCharLength(val);
            });
        },
        calcCharLength: function calcCharLength(val) {
            val = val + '';
            var charLength = 0;
            var maxLength = +this.data.get('maxLength');
            charLength = maxLength && val ? val.length : 0;
            this.data.set('charLength', charLength);
            var isTextOverflow = this.data.get('isTextOverflow');
            if (charLength > maxLength && !isTextOverflow) {
                this.data.set('isTextOverflow', true);
                this.fire('textOverflow', 'true');
            }
            if (isTextOverflow && charLength <= maxLength) {
                this.data.set('isTextOverflow', false);
                this.fire('textOverflow', 'false');
            }
        },
        handleFocus: function handleFocus(event) {
            this.data.set('focus', true);
            this.fire('input-focus', event);
        },
        handleBlur: function handleBlur(event) {
            this.data.set('focus', false);
            this.fire('input-blur', event);
        },
        handleChange: function handleChange(event) {
            var value = event.target.value;
            this.data.set('inputValue', value);
            this.fire('input-change', event);
        },
        handleKeyup: function handleKeyup(event) {
            this.fire('input-keyup', event);
        },
        handleKeypress: function handleKeypress(event) {
            this.fire('input-keypress', event);
        },
        handleKeydown: function handleKeydown(event) {
            this.fire('input-keydown', event);
        },


        components: {
            'sm-icon': _index2.default,
            'underline': _TextFieldUnderline2.default,
            'enhanced-textarea': _TextFieldEnhancedTextarea2.default,
            'text-field-label': _TextFieldLabel2.default,
            'text-field-hint': _TextFieldHint2.default
        }
    });
});
//# sourceMappingURL=TextField.js.map
