(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.babelHelpers);
        global.TextFieldEnhancedTextarea = mod.exports;
    }
})(this, function (exports, _san, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    exports.default = _san2.default.defineComponent({
        template: '\n        <div class="sm-text-field-multiline">\n            <textarea s-ref="text-field-hidden" class="sm-text-field-textarea-hide sm-text-field-input" value="{=value=}"></textarea>\n            <textarea s-ref="text-field" class="sm-text-field-input sm-text-field-textarea {{normalClass}}"\n                value="{= value =}"\n                on-input="handleInput($event)"\n                on-focus="handleFocus($event)"\n                on-blur="handleBlur($event)"\n                on-keyup="handleKeyup($event)"\n                on-keypress="handleKeypress($event)"\n                on-keydown="handleKeydown($event)"\n                placeholder="{{placeholder}}"\n                readonly="{{readOnly}}"\n                disabled="{{disabled}}"/>\n        </div>\n    ',
        initData: function initData() {
            return {
                placeholder: '',
                value: '',
                rows: 0,
                rowsMax: 0,
                disabled: false,
                normalClass: ''
            };
        },
        resizeTextarea: function resizeTextarea() {
            var element = this.ref('text-field');
            var hiddenEl = this.ref('text-field-hidden');
            var lineHeight = window.getComputedStyle(element, null).getPropertyValue('line-height');
            lineHeight = parseFloat(lineHeight);
            var pt = window.getComputedStyle(element, null).getPropertyValue('padding-top');
            pt = parseFloat(pt);
            var pd = window.getComputedStyle(element, null).getPropertyValue('padding-bottom');
            pd = parseFloat(pd);
            var rows = this.data.get('rows') || 0;
            var rowsMax = this.data.get('rowsMax') || 0;
            var minHeight = pd + pt + lineHeight * rows;
            var maxHeight = pd + pt + lineHeight * rowsMax;
            var height = hiddenEl.scrollHeight;
            var styleHeight = height < minHeight ? minHeight : height > maxHeight && maxHeight > 0 ? maxHeight : height;
            element.style.height = styleHeight + 'px';
        },
        handleInput: function handleInput(e) {
            this.fire('input', e);
        },
        handleFocus: function handleFocus(e) {
            this.fire('focus', e);
        },
        handleBlur: function handleBlur(e) {
            this.fire('blur', e);
        },
        handleKeydown: function handleKeydown(e) {
            this.fire('keydown', e);
        },
        handleKeyup: function handleKeyup(e) {
            this.fire('keyup', e);
        },
        handleKeypress: function handleKeypress(e) {
            this.fire('keypress', e);
        },
        attached: function attached() {
            var _this = this;

            this.resizeTextarea();
            this.watch('value', function (value) {
                setTimeout(function () {
                    _this.resizeTextarea();
                }, 1);
            });
        }
    });
});
//# sourceMappingURL=TextFieldEnhancedTextarea.js.map
