(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', 'classnames', '../common/util/cx', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('classnames'), require('../common/util/cx'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.classnames, global.cx, global.babelHelpers);
        global.TextFieldHint = mod.exports;
    }
})(this, function (exports, _san, _classnames, _cx, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var _classnames2 = babelHelpers.interopRequireDefault(_classnames);

    var cx = (0, _cx.create)('text-field-hint');

    exports.default = _san2.default.defineComponent({
        template: '\n        <div class="{{computedClass}}">\n            {{text}}\n        </div>\n    ',
        initData: function initData() {
            return {
                text: '',
                show: true
            };
        },

        computed: {
            computedClass: function computedClass() {
                var show = this.data.get('show');
                var hintTextClass = this.data.get('hintTextClass');
                return (0, _classnames2.default)(cx(this).addStates({ show: show }).build(), hintTextClass ? hintTextClass : '');
            }
        }
    });
});
//# sourceMappingURL=TextFieldHint.js.map
