(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', 'classnames', '../common/util/cx', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('classnames'), require('../common/util/cx'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.classnames, global.cx, global.babelHelpers);
        global.TextFieldLabel = mod.exports;
    }
})(this, function (exports, _san, _classnames, _cx, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var _classnames2 = babelHelpers.interopRequireDefault(_classnames);

    var cx = (0, _cx.create)('text-field-label');

    exports.default = _san2.default.defineComponent({
        template: '\n        <div class="{{labelClass}}">\n          <slot></slot>\n        </div>\n    ',
        initData: function initData() {
            return {
                text: '',
                show: true,
                labelClass: ''
            };
        },


        computed: {
            labelClass: function labelClass() {
                var float = this.data.get('float');
                var focus = this.data.get('focus');
                var focusClass = this.data.get('focusClass');
                var labelClass = this.data.get('normalClass');
                return (0, _classnames2.default)(cx(this).addStates({ float: float }).build(), focus ? focusClass : '', labelClass ? labelClass : '');
            }
        }
    });
});
//# sourceMappingURL=TextFieldLabel.js.map
