(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', 'classnames', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('classnames'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.classnames, global.babelHelpers);
        global.TextFieldUnderline = mod.exports;
    }
})(this, function (exports, _san, _classnames, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var _classnames2 = babelHelpers.interopRequireDefault(_classnames);

    exports.default = _san2.default.defineComponent({
        template: '\n        <div>\n            <hr class="{{computedClass}}"/>\n            <hr san-if="!disabled"\n                class="{{focusLineClass}}"\n                style="{{errorColor ? (\'background-color:\' + errorColor) : \'\'}}"/>\n        </div>\n    ',
        initData: function initData() {
            return {
                focus: false,
                error: false,
                errorColor: '',
                disabled: false,
                normalClass: '',
                focusClass: '',
                focusLineClass: '',
                lineClass: ''
            };
        },


        computed: {
            computedClass: function computedClass() {
                var disabled = this.data.get('disabled');
                var normalClass = this.data.get('normalClass');
                return (0, _classnames2.default)('sm-text-field-line', { disabled: disabled }, normalClass ? normalClass : '');
            },
            focusLineClass: function focusLineClass() {
                var error = this.data.get('error');
                var focus = this.data.get('focus');
                var focusClass = this.data.get('focusClass');
                var normalClass = this.data.get('normalClass');
                return (0, _classnames2.default)('sm-text-field-focus-line', normalClass ? normalClass : '', { error: error }, { focus: focus }, focus ? focusClass : '');
            }
        }
    });
});
//# sourceMappingURL=TextFieldUnderline.js.map
