(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', 'classnames', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('classnames'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.classnames, global.babelHelpers);
        global.Clock = mod.exports;
    }
})(this, function (exports, _san, _classnames, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var _classnames2 = babelHelpers.interopRequireDefault(_classnames);

    function getMaxValue(type) {
        switch (type) {
            case '12hour':
                return 12;
            case '24hour':
                return 24;
            case 'minute':
                return 60;
        }
    }

    var Clock = function (_san$Component) {
        babelHelpers.inherits(Clock, _san$Component);

        function Clock() {
            babelHelpers.classCallCheck(this, Clock);
            return babelHelpers.possibleConstructorReturn(this, (Clock.__proto__ || Object.getPrototypeOf(Clock)).apply(this, arguments));
        }

        babelHelpers.createClass(Clock, [{
            key: 'initData',
            value: function initData() {
                return {
                    type: 'hour',
                    value: 0,
                    r: 130,
                    step: 30 / 180 * Math.PI,
                    blockSizes: [32, 28],
                    items: []
                };
            }
        }, {
            key: 'inited',
            value: function inited() {
                var _this2 = this;

                var _data$get = this.data.get(),
                    type = _data$get.type,
                    value = _data$get.value;

                var items = this.getItems(type);

                this.data.set('items', items);
                this.data.set('_value', value);

                this.onMouseUp = this.onMouseUp.bind(this);
                this.onMouseMove = this.onMouseMove.bind(this);

                this.watch('type', function (type) {
                    _this2.data.set('items', _this2.getItems(type));
                });

                this.watch('value', function (value) {
                    if (_this2.data.get('_value') !== value) {
                        _this2.data.set('_value', value);
                    }
                });
            }
        }, {
            key: 'getItems',
            value: function getItems(type) {

                switch (type) {
                    case '12hour':
                        return Array.apply(null, new Array(12)).map(function (_, i) {

                            return {
                                text: i === 0 ? 12 : i,
                                value: i
                            };
                        });

                    case '24hour':

                        return Array.apply(null, new Array(24)).map(function (_, i) {

                            switch (i) {
                                case 0:
                                    return {
                                        text: '12',
                                        value: 12
                                    };
                                case 12:
                                    return {
                                        text: '00',
                                        value: 0
                                    };
                                default:
                                    return {
                                        text: i,
                                        value: i
                                    };
                            }
                        });

                    case 'minute':
                        return Array.apply(null, new Array(12)).map(function (_, i) {

                            return {
                                text: i === 0 ? '00' : i * 5,
                                value: i * 5
                            };
                        });
                }
            }
        }, {
            key: 'onMouseDown',
            value: function onMouseDown(e) {

                if (e.button !== 0) {
                    return;
                }

                this.bindWindowEvents();
            }
        }, {
            key: 'onMouseMove',
            value: function onMouseMove(e) {
                this.updateValue(this.resolveMousePosition(e));
            }
        }, {
            key: 'onMouseUp',
            value: function onMouseUp(e) {

                this.updateValue(this.resolveMousePosition(e));

                this.unbindWindowEvents();

                this.fire('confirm');
            }
        }, {
            key: 'updateValue',
            value: function updateValue(_ref) {
                var rotate = _ref.rotate,
                    radius = _ref.radius;


                var type = this.data.get('type');
                var max = getMaxValue(type);
                var value = void 0;

                switch (type) {

                    case '24hour':
                        {
                            value = Math.round(rotate / 360 * 12) % 12;

                            var isInnerRound = radius < 87;

                            if (value === 0) {
                                value = isInnerRound ? 0 : 12;
                            } else if (isInnerRound) {
                                    value += 12;
                                }
                            break;
                        }

                    case '12hour':
                        {
                            value = Math.round(rotate / 360 * max) % max;
                            if (value === 0) {
                                value = 12;
                            }
                            break;
                        }

                    case 'minute':
                        {
                            value = Math.round(rotate / 360 * max) % max;
                            break;
                        }

                }

                this.data.set('_value', value);

                this.fire('change', value);
            }
        }, {
            key: 'resolveMousePosition',
            value: function resolveMousePosition(e) {
                var r = this.data.get('r');
                var clientX = e.clientX,
                    clientY = e.clientY;

                var _e$target$getBounding = e.target.getBoundingClientRect(),
                    top = _e$target$getBounding.top,
                    left = _e$target$getBounding.left;

                var x = clientX - left - r;
                var y = clientY - top - r;
                var radius = Math.sqrt(x * x + y * y);
                var rotate = 180 - (x > 0 ? 1 : -1) * Math.acos(y / radius) / Math.PI * 180;
                return {
                    radius: radius,
                    rotate: rotate
                };
            }
        }, {
            key: 'bindWindowEvents',
            value: function bindWindowEvents() {
                window.addEventListener('mousemove', this.onMouseMove);
                window.addEventListener('mouseup', this.onMouseUp);
            }
        }, {
            key: 'unbindWindowEvents',
            value: function unbindWindowEvents() {
                window.removeEventListener('mousemove', this.onMouseMove);
                window.removeEventListener('mouseup', this.onMouseUp);
            }
        }, {
            key: 'detached',
            value: function detached() {
                this.unbindWindowEvents();
            }
        }]);
        return Clock;
    }(_san2.default.Component);

    Clock.template = '\n        <div class="sm-time-picker-clock" on-mousedown="onMouseDown($event)">\n            <div style="pointer-events: none">\n                <b\n                    class="{{pointerClassName}}"\n                    style="{{pointerStyle}}" />\n                <i\n                    san-for="item, i in items"\n                    class="{{numberClassName[i]}}"\n                    style="{{numberStyle[i]}}">\n                    {{item.text}}\n                </i>\n            </div>\n        </div>\n    ';
    Clock.computed = {
        pointerClassName: function pointerClassName() {
            var type = this.data.get('type');
            return (0, _classnames2.default)('sm-time-picker-clock-pointer', type === 'minute' ? 'variant-minute' : null);
        },
        pointerStyle: function pointerStyle() {
            var type = this.data.get('type');
            var value = this.data.get('_value');
            var round = type === '24hour' && (value === 0 || value > 12) ? 1 : 0;
            var rate = type === 'minute' ? 60 : 12;
            return {
                transform: 'rotate(' + Math.round(value / rate * 360 - 180) % 360 + 'deg)',
                height: (type === '24hour' && round === 1 ? 80 : 102) + 'px'
            };
        },
        numberClassName: function numberClassName() {

            var items = this.data.get('items');
            var value = this.data.get('_value');

            var result = items.map(function (item, i) {
                return (0, _classnames2.default)('sm-time-picker-clock-number', 'variant-round-' + (i >= 12 ? 2 : 1), {
                    'state-selected': value === item.value
                });
            });

            return result;
        },
        numberStyle: function numberStyle() {
            var items = this.data.get('items');
            var r = this.data.get('r');
            var blockSizes = this.data.get('blockSizes');
            var step = this.data.get('step');
            return items.map(function (_, index) {

                var round = Math.floor(index / 12);
                var radius = r;

                for (var i = 0; i <= round; i++) {
                    radius -= blockSizes[i] * 0.75 + i * 12;
                }

                var x = (r + radius * Math.sin(index * step)).toFixed(2);
                var y = (r - radius * Math.cos(index * step)).toFixed(2);

                return {
                    transform: 'translate(' + x + 'px, ' + y + 'px)',
                    left: -blockSizes[round] / 2 + 'px',
                    top: -blockSizes[round] / 2 + 'px',
                    width: blockSizes[round] + 'px',
                    height: blockSizes[round] + 'px'
                };
            });
        }
    };
    exports.default = Clock;
});
//# sourceMappingURL=Clock.js.map
