(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.babelHelpers);
        global.Header = mod.exports;
    }
})(this, function (exports, _san, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var Header = function (_san$Component) {
        babelHelpers.inherits(Header, _san$Component);

        function Header() {
            babelHelpers.classCallCheck(this, Header);
            return babelHelpers.possibleConstructorReturn(this, (Header.__proto__ || Object.getPrototypeOf(Header)).apply(this, arguments));
        }

        babelHelpers.createClass(Header, [{
            key: 'initData',
            value: function initData() {
                return {
                    meridiem: 'am'
                };
            }
        }, {
            key: 'setClockToHour',
            value: function setClockToHour() {
                this.fire('change', 'hour');
            }
        }, {
            key: 'setClockToMinute',
            value: function setClockToMinute() {
                this.fire('change', 'minute');
            }
        }, {
            key: 'setAM',
            value: function setAM() {
                this.fire('change-meridiem', 'ante');
            }
        }, {
            key: 'setPM',
            value: function setPM() {
                this.fire('change-meridiem', 'post');
            }
        }]);
        return Header;
    }(_san2.default.Component);

    Header.template = '\n        <div class="sm-time-picker-header">\n            <span\n                class="sm-time-picker-header-text {{panel !== \'minute\' ? \'state-selected\' : \'\'}}"\n                on-click="setClockToHour">\n                {{_hour}}\n            </span>\n            <b>:</b>\n            <span\n                class="sm-time-picker-header-text {{panel === \'minute\' ? \'state-selected\' : \'\'}}"\n                on-click="setClockToMinute">\n                {{minute}}\n            </span>\n            <div\n                san-if="type === \'12hour\'"\n                class="sm-time-picker-header-meridiem">\n                <span\n                    class="{{meridiem === \'ante\' ? \'state-active\' : \'\'}}"\n                    on-click="setAM">\n                    AM\n                </span>\n                <span\n                    class="{{meridiem === \'post\' ? \'state-active\' : \'\'}}"\n                    on-click="setPM">\n                    PM\n                </span>\n            </div>\n        </div>\n    ';
    Header.computed = {
        _hour: function _hour() {
            var hour = this.data.get('hour');
            var type = this.data.get('type');
            return type === '12hour' && +hour === 0 ? '12' : hour;
        }
    };
    exports.default = Header;
});
//# sourceMappingURL=Header.js.map
