(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', 'moment', '../Dialog/index', '../Button/index', '../TextField/index', './Clock', './Header', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('moment'), require('../Dialog/index'), require('../Button/index'), require('../TextField/index'), require('./Clock'), require('./Header'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.moment, global.index, global.index, global.index, global.Clock, global.Header, global.babelHelpers);
        global.TimePicker = mod.exports;
    }
})(this, function (exports, _san, _moment, _index, _index3, _index5, _Clock, _Header, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _moment2 = babelHelpers.interopRequireDefault(_moment);

    var _index2 = babelHelpers.interopRequireDefault(_index);

    var _index4 = babelHelpers.interopRequireDefault(_index3);

    var _index6 = babelHelpers.interopRequireDefault(_index5);

    var _Clock2 = babelHelpers.interopRequireDefault(_Clock);

    var _Header2 = babelHelpers.interopRequireDefault(_Header);

    var INTERNAL_FORMAT = 'HH:mm';

    var TimePicker = function (_Component) {
        babelHelpers.inherits(TimePicker, _Component);

        function TimePicker() {
            babelHelpers.classCallCheck(this, TimePicker);
            return babelHelpers.possibleConstructorReturn(this, (TimePicker.__proto__ || Object.getPrototypeOf(TimePicker)).apply(this, arguments));
        }

        babelHelpers.createClass(TimePicker, [{
            key: 'initData',
            value: function initData() {
                return {
                    open: false,
                    type: '24hour',
                    meridiem: 'ante',

                    locale: 'zh-cn',

                    label: '',
                    labelFloat: false,
                    labelClass: '',
                    labelFocusClass: '',
                    hintText: '选择时间',
                    hintTextClass: '',
                    inputClass: '',
                    errorText: '',
                    errorColor: '',
                    helpText: '',
                    helpTextClass: '',
                    maxLength: 0,
                    disabled: false,
                    fullWidth: false,
                    underlineShow: true,
                    underlineClass: '',
                    underlineFocusClass: '',
                    focus: false,
                    inputValue: '',
                    charLength: 0,
                    float: true,
                    multiLine: false,
                    icon: ''
                };
            }
        }, {
            key: 'inited',
            value: function inited() {
                var _this2 = this;

                var _data$get = this.data.get(),
                    value = _data$get.value,
                    format = _data$get.format,
                    type = _data$get.type;

                this.data.set('panel', type);

                if (!format) {
                    format = type === '12hour' ? 'hh:mm a' : 'HH:mm';
                    this.data.set('format', format);
                }

                var date = (0, _moment2.default)(value, format);

                if (!date.isValid()) {
                    date = (0, _moment2.default)();
                }

                this.data.set('date', date.format(INTERNAL_FORMAT));

                this.watch('type', function (type) {
                    _this2.data.set('panel', type);
                });
            }
        }, {
            key: 'openPicker',
            value: function openPicker() {
                this.data.set('open', true);
            }
        }, {
            key: 'onPanelChange',
            value: function onPanelChange(panel) {
                var type = this.data.get('type');
                this.data.set('panel', panel === 'hour' ? type : panel);
            }
        }, {
            key: 'onClockChange',
            value: function onClockChange(value) {
                var _data$get2 = this.data.get(),
                    date = _data$get2.date,
                    panel = _data$get2.panel;

                date = (0, _moment2.default)(date, INTERNAL_FORMAT);

                if (panel === 'minute') {
                    date.minute(+value);
                } else {
                    date.hour(+value);
                }

                this.data.set('date', date.format(INTERNAL_FORMAT));
            }
        }, {
            key: 'onClockConfirm',
            value: function onClockConfirm() {
                this.data.set('panel', 'minute');
            }
        }, {
            key: 'onMeridiemChange',
            value: function onMeridiemChange(meridiem) {
                var date = (0, _moment2.default)(this.data.get('date'), INTERNAL_FORMAT);
                var hour = date.hour();
                date.hour(hour % 12 + (meridiem === 'ante' ? 0 : 12));
                this.data.set('date', date.format(INTERNAL_FORMAT));
                this.data.set('meridiem', meridiem);
            }
        }, {
            key: 'cancel',
            value: function cancel() {
                this.data.set('open', false);

                this.data.set('panel', this.data.get('type'));
            }
        }, {
            key: 'confirm',
            value: function confirm() {
                var _data$get3 = this.data.get(),
                    date = _data$get3.date,
                    format = _data$get3.format,
                    locale = _data$get3.locale;

                date = (0, _moment2.default)(date, INTERNAL_FORMAT);

                var nextValue = date.locale(locale).format(format);

                this.data.set('value', nextValue);

                this.data.set('open', false);

                this.data.set('panel', this.data.get('type'));
            }
        }, {
            key: 'detached',
            value: function detached() {
                if (this.timer) {
                    clearTimeout(this.timer);
                    this.timer = null;
                }
            }
        }]);
        return TimePicker;
    }(_san.Component);

    TimePicker.template = '\n        <div class="sm-time-picker">\n            <san-text-field\n                label="{{label}}"\n                labelFloat="{{labelFloat}}"\n                labelClass="{{labelClass}}"\n                labelFocusClass="{{labelFocusClass}}"\n                hintText="{{hintText}}"\n                hintTextClass="{{hintTextClass}}"\n                inputClass="{{inputClass}}"\n                errorText="{{errorText}}"\n                errorColor="{{errorColor}}"\n                helpText="{{helpText}}"\n                helpTextClass="{{helpTextClass}}"\n                maxLength="{{maxLength}}"\n                disabled="{{disabled}}"\n                readOnly="{{!0}}"\n                fullWidth="{{fullWidth}}"\n                underlineShow="{{!0}}"\n                focus="{{!1}}"\n                inputValue="{=value=}"\n                charLength="{{charLength}}"\n                float="{{float}}"\n                multiLine="{{multiLine}}"\n                icon="{{icon}}"\n                on-input-focus="openPicker" />\n            <san-dialog\n                variants="time-picker"\n                useMask="{{!0}}"\n                closeOnClickMask="{{false}}"\n                open="{=open=}"\n                width="{{310}}">\n                <san-header\n                    slot="title"\n                    type="{{type}}"\n                    panel="{{panel}}"\n                    hour="{{hour}}"\n                    minute="{{minute}}"\n                    meridiem="{{meridiem}}"\n                    on-change="onPanelChange($event)"\n                    on-change-meridiem="onMeridiemChange($event)" />\n                <san-clock\n                    type="{{panel}}"\n                    value="{{clockValue}}"\n                    meridiem="{{meridiem}}"\n                    on-change="onClockChange($event)"\n                    on-confirm="onClockConfirm" />\n                <footer slot="actions">\n                    <san-button on-click="cancel" variants="info">\u53D6\u6D88</san-button>\n                    <san-button on-click="confirm" variants="info">\u786E\u8BA4</san-button>\n                </footer>\n            </san-dialog>\n        </div>\n    ';
    TimePicker.components = {
        'san-button': _index4.default,
        'san-dialog': _index2.default,
        'san-text-field': _index6.default,
        'san-clock': _Clock2.default,
        'san-header': _Header2.default
    };
    TimePicker.computed = {
        clockValue: function clockValue() {

            var panel = this.data.get('panel');
            var date = this.data.get('date');
            var method = panel === 'minute' ? 'minute' : 'hour';
            var value = (0, _moment2.default)(date, INTERNAL_FORMAT)[method]();

            return panel === '12hour' ? value % 12 : value;
        },
        hour: function hour() {
            var type = this.data.get('type');
            var date = this.data.get('date');

            if (date == null) {
                return '';
            }

            date = (0, _moment2.default)(date, INTERNAL_FORMAT);

            if (type === '12hour' && date.hour() >= 12) {
                date.hour(date.hour() - 12);
            }

            return date.format('HH');
        },
        minute: function minute() {
            var date = this.data.get('date');
            return date == null ? '' : (0, _moment2.default)(date, INTERNAL_FORMAT).format('mm');
        }
    };
    TimePicker.dataTypes = babelHelpers.extends({}, _index6.default.dataTypes, {
        open: _san.DataTypes.bool,
        type: _san.DataTypes.oneOf(['24hour', '12hour']),
        locale: _san.DataTypes.string
    });
    exports.default = TimePicker;
});
//# sourceMappingURL=TimePicker.js.map
