(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../common/util/cx', '../common/util/css', '../Layer/index', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../common/util/cx'), require('../common/util/css'), require('../Layer/index'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.cx, global.css, global.index, global.babelHelpers);
        global.Toast = mod.exports;
    }
})(this, function (exports, _san, _cx, _css, _index, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _css2 = babelHelpers.interopRequireDefault(_css);

    var _index2 = babelHelpers.interopRequireDefault(_index);

    var cx = (0, _cx.create)('toast');

    var POSITION_BASE_MAP = {
        leftTop: {
            left: '24px',
            top: '-24px'
        },
        rightTop: {
            right: '24px',
            top: '-24px'
        },
        leftBottom: {
            left: '24px',
            bottom: '-24px'
        },
        rightBottom: {
            right: '24px',
            bottom: '-24px'
        }
    };

    var POSITION_TRANSLATE_MAP = {
        leftTop: 1,
        rightTop: 1,
        leftBottom: -1,
        rightBottom: -1
    };

    var Toast = function (_Layer) {
        babelHelpers.inherits(Toast, _Layer);

        function Toast() {
            babelHelpers.classCallCheck(this, Toast);
            return babelHelpers.possibleConstructorReturn(this, (Toast.__proto__ || Object.getPrototypeOf(Toast)).apply(this, arguments));
        }

        babelHelpers.createClass(Toast, [{
            key: 'initData',
            value: function initData() {
                return {
                    open: false,
                    position: 'rightBottom',
                    duration: 2000
                };
            }
        }, {
            key: 'onClickAway',
            value: function onClickAway(e) {

                var el = this.el;

                if (e.target !== el && !el.contains(e.target)) {
                    this.data.set('open', false);
                    this.clearHideTimer();
                }
            }
        }, {
            key: 'bindToWindow',
            value: function bindToWindow() {
                window.addEventListener('click', this.onClickAway, true);
            }
        }, {
            key: 'unbindToWindow',
            value: function unbindToWindow() {
                window.removeEventListener('click', this.onClickAway, true);
            }
        }, {
            key: 'clearHideTimer',
            value: function clearHideTimer() {
                if (this.hideTimer) {
                    clearTimeout(this.hideTimer);
                    this.hideTimer = null;
                }
            }
        }, {
            key: 'inited',
            value: function inited() {
                this.onClickAway = this.onClickAway.bind(this);
            }
        }, {
            key: 'attached',
            value: function attached() {
                var _this2 = this;

                babelHelpers.get(Toast.prototype.__proto__ || Object.getPrototypeOf(Toast.prototype), 'attached', this).call(this);
                this.watch('open', function (open) {

                    if (!open) {
                        _this2.clearHideTimer();
                        _this2.unbindToWindow();
                        return;
                    }

                    _this2.bindToWindow();

                    _this2.clearHideTimer();

                    _this2.hideTimer = setTimeout(function () {
                        _this2.data.set('open', false);
                        _this2.unbindToWindow();
                    }, _this2.data.get('duration'));
                });
            }
        }, {
            key: 'detached',
            value: function detached() {
                babelHelpers.get(Toast.prototype.__proto__ || Object.getPrototypeOf(Toast.prototype), 'detached', this).call(this);
                this.clearHideTimer();
                this.unbindToWindow();
            }
        }]);
        return Toast;
    }(_index2.default);

    Toast.template = '\n        <div\n            class="{{computedClassName}}"\n            style="{{wrapperStyle}}">\n\n            <span\n                class="' + cx.getPartClassName('content') + '"\n                style="{{contentStyle}}">\n                {{message}}\n            </span>\n            <slot></slot>\n        </div>\n    ';
    Toast.dataTypes = {
        open: _san.DataTypes.bool,
        position: _san.DataTypes.oneOf(['leftTop', 'rightTop', 'leftBottom', 'rightBottom'])
    };
    Toast.computed = {
        computedClassName: function computedClassName() {
            var open = this.data.get('open');
            var position = this.data.get('position');
            return cx(this).addStates({
                open: open,
                hidden: !open
            }).addVariants(position).build();
        },
        wrapperStyle: function wrapperStyle() {
            var open = this.data.get('open');
            var position = this.data.get('position');
            var visibility = open ? 'visible' : 'hidden';
            var transform = open ? 'translate(0, ' + POSITION_TRANSLATE_MAP[position] * 48 + 'px)' : '';
            var opacity = open ? 1 : 0;

            return (0, _css2.default)(babelHelpers.extends({}, POSITION_BASE_MAP[position], {
                transform: transform,
                visibility: visibility,
                opacity: opacity
            }));
        },
        contentStyle: function contentStyle() {
            var open = this.data.get('open');
            var opacity = open ? 1 : 0;

            return (0, _css2.default)({
                opacity: opacity
            });
        }
    };
    exports.default = Toast;
});
//# sourceMappingURL=Toast.js.map
