(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../common/util/cx', '../Popover/Popover', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../common/util/cx'), require('../Popover/Popover'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.cx, global.Popover, global.babelHelpers);
        global.Tooltip = mod.exports;
    }
})(this, function (exports, _san, _cx, _Popover, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _Popover2 = babelHelpers.interopRequireDefault(_Popover);

    var cx = (0, _cx.create)('tooltip');

    var SOURCE_ORIGIN_MAP = {
        left: 'cr',
        right: 'cl',
        top: 'bc',
        bottom: 'tc'
    };

    var TARGET_ORIGIN_MAP = {
        left: 'cl',
        right: 'cr',
        top: 'tc',
        bottom: 'bc'
    };

    var OFFSET_MAP = {
        left: [-1, 0],
        right: [1, 0],
        top: [0, -1],
        bottom: [0, 1]
    };

    var Tooltip = function (_Component) {
        babelHelpers.inherits(Tooltip, _Component);

        function Tooltip() {
            babelHelpers.classCallCheck(this, Tooltip);
            return babelHelpers.possibleConstructorReturn(this, (Tooltip.__proto__ || Object.getPrototypeOf(Tooltip)).apply(this, arguments));
        }

        babelHelpers.createClass(Tooltip, [{
            key: 'initData',
            value: function initData() {
                return {
                    open: false,
                    mode: 'click',
                    position: 'bottom',
                    maxWidth: null,
                    maxHeight: null,
                    offset: 8,

                    getAnchor: this.getPopoverAnchor.bind(this)
                };
            }
        }, {
            key: 'getPopoverAnchor',
            value: function getPopoverAnchor() {
                return this.el;
            }
        }, {
            key: 'onMouseEnter',
            value: function onMouseEnter() {
                if (this.data.get('mode') === 'hover') {
                    this.showPopover();
                }
            }
        }, {
            key: 'onMouseLeave',
            value: function onMouseLeave() {
                if (this.data.get('mode') === 'hover') {
                    this.hidePopover();
                }
            }
        }, {
            key: 'onClick',
            value: function onClick() {
                if (this.data.get('mode') === 'click') {
                    this.data.get('open') ? this.hidePopover() : this.showPopover();
                }
            }
        }, {
            key: 'showPopover',
            value: function showPopover() {
                this.data.set('open', true);
            }
        }, {
            key: 'hidePopover',
            value: function hidePopover() {
                this.data.set('open', false);
            }
        }]);
        return Tooltip;
    }(_san.Component);

    Tooltip.template = '\n        <div\n            class="sm-tooltip"\n            on-click="onClick"\n            on-mouseenter="onMouseEnter"\n            on-mouseleave="onMouseLeave">\n            <sm-popover\n                variants="tooltip"\n                anchorOrigin="{{anchorOrigin}}"\n                targetOrigin="{{targetOrigin}}"\n                getAnchor="{{getAnchor}}"\n                open="{=open=}"\n                maxWidth="{{maxWidth}}"\n                maxHeight="{{maxHeight}}"\n                offsetX="{{offsetX}}"\n                offsetY="{{offsetY}}">\n                <slot name="title">{{title}}</slot>\n            </sm-popover>\n            <slot />\n        </div>\n    ';
    Tooltip.computed = {
        className: function className() {
            return cx(this).addStates({
                fluid: this.data.get('fullWidth')
            }).build();
        },
        anchorOrigin: function anchorOrigin() {
            return TARGET_ORIGIN_MAP[this.data.get('position')];
        },
        targetOrigin: function targetOrigin() {
            return SOURCE_ORIGIN_MAP[this.data.get('position')];
        },
        offsetX: function offsetX() {
            var position = this.data.get('position');
            var offset = this.data.get('offset');
            var rate = OFFSET_MAP[position];
            return rate[0] * offset;
        },
        offsetY: function offsetY() {
            var position = this.data.get('position');
            var offset = this.data.get('offset');
            var rate = OFFSET_MAP[position];
            return rate[1] * offset;
        }
    };
    Tooltip.components = {
        'sm-popover': _Popover2.default
    };
    Tooltip.dataTypes = {
        open: _san.DataTypes.bool,
        mode: _san.DataTypes.oneOf(['click', 'hover']),
        position: _san.DataTypes.oneOf(['left', 'right', 'top', 'bottom']),
        maxWidth: _san.DataTypes.number,
        maxHeight: _san.DataTypes.number,
        offset: _san.DataTypes.number
    };
    exports.default = Tooltip;
});
//# sourceMappingURL=Tooltip.js.map
