(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../Icon/index', '../TextField/index', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../Icon/index'), require('../TextField/index'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.index, global.index, global.babelHelpers);
        global.TreeView = mod.exports;
    }
})(this, function (exports, _san, _index, _index2, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var _index3 = babelHelpers.interopRequireDefault(_index2);

    exports.default = _san2.default.defineComponent({

        template: '\n        <div class="sm-tree-view {{treeViewClass}}">\n            <div\n                class="sm-tree-view-filter-bar {{treeViewClass}}"\n                san-if="filterBar"\n            >\n                <san-text-field\n                    hintText="{=filterBarHintText=}"\n                    inputValue="{=filterText=}"\n                    fullWidth\n                    on-input-keypress="doHighlight($event)"\n                    on-input-focus="captureFilterInput($event)"\n                />\n            </div>\n            <slot></slot>\n        </div>\n    ',

        defaultData: function defaultData() {
            return {
                compact: false,
                wholeLineSelected: false,
                keepingSelected: false,
                filterBar: false,
                filterBarHintText: '',
                dataSource: 'ATTRIBUTE'
            };
        },


        dataTypes: {
            compact: _san.DataTypes.bool,
            wholeLineSelected: _san.DataTypes.bool,
            keepingSelected: _san.DataTypes.bool,
            filterBar: _san.DataTypes.bool,
            filterBarHintText: _san.DataTypes.string,
            dataSource: _san.DataTypes.oneOf(['ATTRIBUTE', 'JSON'])
        },

        components: {
            'san-icon': _index.Icon,
            'san-text-field': _index3.default
        },

        inited: function inited() {
            this.items = [];
            this.highlightItems = [];
            this.filterInput = null;
        },
        initData: function initData() {
            return {
                filterText: '',
                lastFilterText: ''
            };
        },
        attached: function attached() {
            var _this = this;

            this.watch('filterText', function (value, obj) {
                _this.filterItems(value, _this.data.get('lastFilterText'));
                _this.data.set('lastFilterText', value);
            });
        },
        created: function created() {
            this.dispatch('UI:tree-view-created', this);
        },


        messages: {
            'UI:nested-item-toggle': function UINestedItemToggle(arg) {
                if (arg.value) {
                    this.fire('nestedItemToggle', arg.value);
                }
            },
            'UI:tree-view-item-attached': function UITreeViewItemAttached(arg) {
                if (!arg.value) {
                    return;
                }
                this.items.push(arg.value);
            },
            'UI:tree-view-item-detached': function UITreeViewItemDetached(arg) {
                if (!arg.value) {
                    return;
                }
                var index = this.items.indexOf(arg.value);
                if (index > -1) {
                    this.items.splice(index, 1);
                }
            },
            'UI:query-compact-attribute': function UIQueryCompactAttribute(arg) {
                var compact = this.data.get('compact');
                var target = arg.target;
                target && target.data.set('compact', compact);
                target && target.data.set('rippleMarginLeft', compact ? 16 : 32);
                target && target.data.set('contentMarginLeft', compact ? 22 : 48);
            },
            'UI:query-whole-line-selected-attribute': function UIQueryWholeLineSelectedAttribute(arg) {
                arg.target && arg.target.data && arg.target.data.set('wholeLineSelected', this.data.get('wholeLineSelected'));
            },
            'UI:query-keeping-selected-attribute': function UIQueryKeepingSelectedAttribute(arg) {
                arg.target && arg.target.data && arg.target.data.set('keepingSelected', this.data.get('keepingSelected'));
            },
            'UI:record-selected-item': function UIRecordSelectedItem(arg) {
                this.data.set('selectedItem', arg.target);
            },
            'UI:clear-selected-item': function UIClearSelectedItem(arg) {
                var selectedItem = this.data.get('selectedItem');
                selectedItem && selectedItem.data && selectedItem.clearSelectedClass(false);
            },
            'UI:query-filter-bar-attribute': function UIQueryFilterBarAttribute(arg) {
                arg.target && arg.target.data && arg.target.data.set('filterBar', this.data.get('filterBar'));
            },
            'UI:query-filter-text-attribute': function UIQueryFilterTextAttribute(arg) {
                arg.target && arg.target.data && arg.target.data.set('filterText', this.data.get('filterText'));
            },
            'UI:query-checkbox-attribute': function UIQueryCheckboxAttribute(arg) {
                var target = arg.target;
                if (this.data.get('hasCheckbox')) {
                    target.data.set('hasCheckbox', true);
                }
            },
            'UI:query-data-source-attribute': function UIQueryDataSourceAttribute(arg) {
                var target = arg.target;
                if (target.data.get('dataSource') === undefined) {
                    target.data.set('dataSource', this.data.get('dataSource'));
                }
            }
        },

        computed: {
            treeViewClass: function treeViewClass() {
                return this.data.get('compact') ? 'compact ' : '';
            }
        },

        filterItems: function filterItems(value, oldValue) {
            var _this2 = this;

            var filterText = value.toLowerCase();
            if (filterText === '') {
                this.highlightItems.forEach(function (item) {
                    item.highlight(null, _this2.filterInput);
                });
                this.items.forEach(function (item) {
                    item.data.set('hidden', false);
                    if (value === '') {
                        item.data.set('open', item.data.get('lastExpandingState'));
                        item.data.set('lastExpandingState', null);
                    }
                });
                return;
            }
            this.highlightItems.splice(0, this.highlightItems.length);
            this.items.forEach(function (item) {
                var text = (item.data.get('primaryText') + item.data.get('secondaryText')).toLowerCase();
                if (text.indexOf(filterText) === -1 || item.data.get('disabled') && filterText !== '') {
                    item.data.set('hidden', item.data.get('children') > 0 ? true && item.data.get('hidden') : true);
                } else {
                    item.data.set('hidden', false);
                    _this2.highlightItems.push(item);
                }
                if (filterText !== '') {
                    item.dispatch('UI:tree-view-item-hidden');
                    item.dispatch('UI:expand-parent-tree-view-item', {
                        'new': filterText,
                        'old': oldValue
                    });
                }
            });
        },
        doHighlight: function doHighlight(evt) {
            var _this3 = this;

            if (evt.keyCode !== 13) {
                return;
            }
            var filterText = this.data.get('filterText');
            this.highlightItems.forEach(function (item) {
                item.highlight(null, _this3.filterInput);
                filterText !== '' && item.highlight(filterText, _this3.filterInput);
            });
        },
        captureFilterInput: function captureFilterInput(evt) {
            !this.filterInput && (this.filterInput = evt.target);
        },
        rebuildItems: function rebuildItems() {
            this.items.splice(0, this.items.length);
        },
        getAllCheckedItems: function getAllCheckedItems() {
            var items = [];
            if (!this.items || !(this.items instanceof Array)) {
                return items;
            }
            var _iteratorNormalCompletion = true;
            var _didIteratorError = false;
            var _iteratorError = undefined;

            try {
                for (var _iterator = this.items[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                    var i = _step.value;

                    if (i.data.get('checked') === true) {
                        items.push(i);
                    }
                }
            } catch (err) {
                _didIteratorError = true;
                _iteratorError = err;
            } finally {
                try {
                    if (!_iteratorNormalCompletion && _iterator.return) {
                        _iterator.return();
                    }
                } finally {
                    if (_didIteratorError) {
                        throw _iteratorError;
                    }
                }
            }

            return items;
        }
    });
});
//# sourceMappingURL=TreeView.js.map
