(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../Ripple/index', '../Icon/index', '../Checkbox/index', './highlight', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../Ripple/index'), require('../Icon/index'), require('../Checkbox/index'), require('./highlight'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.index, global.index, global.index, global.highlight, global.babelHelpers);
        global.TreeViewItem = mod.exports;
    }
})(this, function (exports, _san, _index, _index2, _index4, _highlight, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var _index3 = babelHelpers.interopRequireDefault(_index2);

    var _index5 = babelHelpers.interopRequireDefault(_index4);

    exports.default = _san2.default.defineComponent({

        template: '\n        <div class="sm-tree-view-item {{itemClass}} {{selectedClass}}\n                    {{hasSecondaryTextClass}} {{checkedClass}}"\n            on-click="toggleTreeView($event)"\n            style="{{itemStyle}}"\n        >\n            <san-touch-ripple s-if="!disableRipple && !disabled"\n                style="{{touchRippleStyle}}"\n                class="{{selectedClass}} {{hiddenClass}}"\n            ></san-touch-ripple>\n            <div class="sm-tree-view-item-content {{selectedClass}}\n                        {{hiddenClass}}"\n                style="{{itemContentStyle}}"\n            >\n                <div class="sm-tree-view-item-left">\n                    <slot name="left"></slot>\n                </div>\n                <san-checkbox\n                    s-if="checked === true || checked === false"\n                    s-ref="checkbox"\n                    nativeValue="{{checkboxValue}}"\n                    disabled="{{disabled}}"\n                    checked="{=checkboxInputValue=}"\n                    indeterminate="{=checkboxIndeterminate=}"\n                    on-change="checkboxChanged($event)"\n                    on-click="checkboxClicked($event)"\n                />\n                <p class="sm-tree-view-item-primary-text"\n                    s-if="primaryText"\n                >{{ treeData ? treeData.text : primaryText }}</p>\n                <p class="sm-tree-view-item-secondary-text"\n                    style="{{secondaryTextStyle}}"\n                    s-if="secondaryText"\n                >{{ treeData ? treeData.secondaryText : secondaryText | raw }}\n                </p>\n                <div class="sm-tree-view-item-right">\n                    <slot name="right"></slot>\n                </div>\n            </div>\n            <div\n                class="sm-tree-view-item-expand {{selectedClass}}\n                       {{hiddenClass}}"\n                s-if="toggleNested"\n                on-click="toggleTreeView($event, \'EXPAND\', false, true)"\n                style="{{expandStyle}}"\n            >\n                <san-icon>arrow_drop_{{ open | treeViewOpenIcon }}</san-icon>\n                <san-center-ripple />\n            </div>\n            <div class="sm-tree-view-item-nested {{ open | treeViewOpen }}"\n                style="{{nestedTreeViewStyle}}"\n            >\n                <slot name="nested" s-if="dataSource!==\'JSON\'"></slot>\n                <san-tree-view-item\n                    s-else\n                    s-for="item, index in treeData.treeData"\n                    s-ref="item_{{index}}"\n                    index="{{index}}"\n                    treeData="{=item=}"\n                    initiallyOpen="{{initiallyOpen}}"\n                    dataSource="JSON"\n                >\n                </san-tree-view-item>\n            </div>\n        </div>\n    ',

        defaultData: function defaultData() {
            return {
                disabled: false,

                hidden: false,

                selected: false,

                disableRipple: false,

                primaryTogglesNestedTreeView: true,

                initiallyOpen: false,

                checked: null,

                dataSource: 'ATTRIBUTE'
            };
        },


        dataTypes: {
            disabled: _san.DataTypes.bool,
            hidden: _san.DataTypes.bool,
            selected: _san.DataTypes.bool,
            disableRipple: _san.DataTypes.bool,
            primaryTogglesNestedTreeView: _san.DataTypes.bool,
            initiallyOpen: _san.DataTypes.bool,
            compact: _san.DataTypes.bool,
            wholeLineSelected: _san.DataTypes.bool,
            keepingSelected: _san.DataTypes.bool,
            checked: _san.DataTypes.bool,
            nestedLevel: _san.DataTypes.number,
            children: _san.DataTypes.number,
            secondaryTextLines: _san.DataTypes.number,
            lastExpandingState: _san.DataTypes.bool,
            checkboxValue: _san.DataTypes.string,
            checkboxInputValue: _san.DataTypes.array,
            checkboxIndeterminate: _san.DataTypes.bool
        },

        components: {
            'san-touch-ripple': _index.TouchRipple,
            'san-center-ripple': _index.CenterRipple,
            'san-checkbox': _index5.default,
            'san-icon': _index3.default,
            'san-tree-view-item': 'self'
        },

        messages: {
            'UI:nested-counter': function UINestedCounter(arg) {
                var target = arg.value;
                target.set('nestedLevel', target.get('nestedLevel') + 1);
                this.dispatch('UI:nested-counter', target);
            },
            'UI:tree-view-item-hidden': function UITreeViewItemHidden(arg) {
                var childHidden = arg.value;
                this.data.set('hidden', childHidden && this.data.get('hidden'));
            },
            'UI:expand-parent-tree-view-item': function UIExpandParentTreeViewItem(arg) {
                if (babelHelpers.typeof(arg.value) === 'object') {
                    if (arg.value.old === '' && this.data.get('lastExpandingState') === null) {
                        this.data.set('lastExpandingState', this.data.get('open'));
                    }
                }
                this.toggleTreeView(document.createEvent('MouseEvent'), '', true, false);
            },
            'UI:tree-view-item-attached': function UITreeViewItemAttached(arg) {
                this.data.set('children', this.data.get('children') + 1);
                this.dispatch('UI:tree-view-item-attached', arg.value);
            },
            'UI:tree-view-item-detached': function UITreeViewItemDetached(arg) {
                if (this.data.get('dataSource') !== 'JSON') {
                    this.data.set('toggleNested', !!this.getNestedAndCheckedSlotChildren().length);
                }
                this.data && this.data.set('children', this.data.get('children') - 1);
                this.dispatch('UI:tree-view-item-detached', arg.value);
            },
            'UI:query-data-source-attribute': function UIQueryDataSourceAttribute(arg) {
                var target = arg.target;
                if (target.data.get('dataSource') === undefined) {
                    target.data.set('dataSource', this.data.get('dataSource'));
                }
            },
            'UI:query-parent-checkbox-state': function UIQueryParentCheckboxState(arg) {
                this.dispatch('UI:query-parent-checkbox-state');
                var child = arg.target;
                if (!child) {
                    return;
                }
                var checked = this.data.get('checked');
                if (typeof checked !== 'boolean') {
                    return;
                }
                if (child.data.get('checked') !== true) {
                    child.data.set('checked', checked);
                }
                if (checked === true) {
                    child.data.set('checked', checked);
                }
            }
        },

        initData: function initData() {
            return {
                nestedLevel: 1,
                children: 0,
                secondaryTextLines: 1,
                lastExpandingState: null,
                checkboxValue: 'ON',
                checkboxInputValue: [],
                checkboxIndeterminate: false
            };
        },


        filters: {
            treeViewOpenIcon: function treeViewOpenIcon(open) {
                return open ? 'down' : 'up';
            },
            treeViewOpen: function treeViewOpen(open) {
                this.data.set('shown', open);
                return open ? '' : 'hide';
            }
        },

        computed: {
            itemStyle: function itemStyle() {
                return {
                    'margin-left': this.data.get('nestedLevel') === 1 ? 0 : this.data.get('rippleMarginLeft') + 'px'
                };
            },
            itemContentStyle: function itemContentStyle() {
                var paddingLeftHasLeft = this.data.get('compact') ? '32px' : '64px';
                var paddingLeftWithoutLeft = this.data.get('compact') ? '6px' : '16px';
                return {
                    'margin-left': this.data.get('contentMarginLeft') + 'px',
                    'padding-left': this.data.get('hasLeft') ? paddingLeftHasLeft : paddingLeftWithoutLeft
                };
            },
            expandStyle: function expandStyle() {
                return {
                    transform: this.data.get('open') ? 'rotate(0)' : 'rotate(90deg)'
                };
            },
            touchRippleStyle: function touchRippleStyle() {
                var level = this.data.get('nestedLevel');
                var leftNormal = this.data.get('wholeLineSelected') ? (1 - level) * this.data.get('rippleMarginLeft') : this.data.get('contentMarginLeft');
                var leftCompact = this.data.get('wholeLineSelected') ? (1 - level) * this.data.get('rippleMarginLeft') : this.data.get('contentMarginLeft');
                if (!leftNormal || !leftCompact) {
                    return;
                }

                return {
                    left: this.data.get('compact') ? leftCompact + 'px' : leftNormal + 'px'
                };
            },
            selectedClass: function selectedClass() {
                return this.data.get('selected') ? 'selected' : '';
            },
            checkedClass: function checkedClass() {
                return this.data.get('checked') === true ? 'checked' : '';
            },
            hiddenClass: function hiddenClass() {
                return this.data.get('hidden') ? 'hidden' : '';
            },
            hasSecondaryTextClass: function hasSecondaryTextClass() {
                return this.data.get('secondaryText') ? 'hasSecondaryText' : '';
            },
            itemClass: function itemClass() {
                return (this.data.get('disabled') ? 'disabled ' : '') + (this.data.get('toggleNested') ? 'nested ' : '') + (this.data.get('compact') ? 'compact' : '');
            },
            secondaryTextStyle: function secondaryTextStyle() {
                return {};
            }
        },

        inited: function inited() {
            var _this = this;

            this.data.set('checked', this.data.get('checked'));
            this.data.set('open', this.data.get('initiallyOpen'));
            this.data.set('dataSource', (this.data.get('dataSource') || '').toUpperCase());

            this.dispatch('UI:nested-counter', this.data);

            this.dispatch('UI:query-compact-attribute');
            this.dispatch('UI:query-whole-line-selected-attribute');
            this.dispatch('UI:query-keeping-selected-attribute');

            this.dispatch('UI:query-data-source-attribute');

            if (this.data.get('dataSource') === 'JSON') {
                this.initFromTreeData(this.data.get('treeData'));
            } else {
                this.generateTreeData();
            }

            this.watch('treeData.checked', function (value) {
                _this.data.set('checked', value, { silence: true });
                _this.data.set('checkboxInputValue', value ? [_this.data.get('checkboxValue')] : [''], {
                    silence: true
                });
                var index = _this.data.get('index');
                _this.parentComponent && _this.parentComponent.data.set('treeData.treeData[' + index + '].checked', value, { silence: true });
            });
            this.watch('treeData.indeterminate', function (value) {
                _this.data.set('checkboxIndeterminate', value, { silence: true });
                var index = _this.data.get('index');
                _this.parentComponent && _this.parentComponent.data.set('treeData.treeData[' + index + '].indeterminate', value, { silence: true });
            });

            this.watch('checkboxInputValue', function (value) {
                _this.data.set('treeData.checked', value && value.toString() !== '');
                _this.data.set('checked', value && value.toString() !== '', {
                    silence: true
                });
                _this.parentComponent && _this.parentComponent.subTag === _this.subTag && _this.parentComponent.updateSelfCheckboxStateFromChildren();
            });

            this.watch('checked', function (value) {
                _this.data.set('treeData.checked', value);
                if (value === null) {
                    return;
                }
                _this.data.set('checkboxInputValue', value ? [_this.data.get('checkboxValue')] : ['']);
            });

            this.watch('checkboxIndeterminate', function (value) {
                _this.data.set('treeData.indeterminate', value);
            });

            this.dispatch('UI:query-parent-checkbox-state');
        },
        attached: function attached() {
            var _this2 = this;

            var slotChildren = this.slotChildren;
            var hasLeft = 0;

            var _iteratorNormalCompletion = true;
            var _didIteratorError = false;
            var _iteratorError = undefined;

            try {
                for (var _iterator = slotChildren[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                    var slot = _step.value;

                    if (slot.name === 'left') {
                        hasLeft++;
                    }
                }
            } catch (err) {
                _didIteratorError = true;
                _iteratorError = err;
            } finally {
                try {
                    if (!_iteratorNormalCompletion && _iterator.return) {
                        _iterator.return();
                    }
                } finally {
                    if (_didIteratorError) {
                        throw _iteratorError;
                    }
                }
            }

            this.data.set('hasLeft', hasLeft);

            this.watch('selected', function (value) {
                _this2.fire('selectedToggle', value);
            });

            this.watch('hidden', function (value) {
                _this2.fire('hiddenToggle', value);
            });

            this.watch('treeData', function (value) {
                if (_this2.data.get('dataSource') !== 'JSON') {
                    return;
                }
                if (!value || (typeof value === 'undefined' ? 'undefined' : babelHelpers.typeof(value)) !== 'object') {
                    return;
                }
                var treeData = value.treeData;
                _this2.data.set('toggleNested', treeData && treeData instanceof Array && treeData.length > 0);
            });
            this.watch('treeData.treeData', function (value) {
                _san2.default.nextTick(function () {
                    this.updateSelfCheckboxStateFromChildren();
                }, _this2);
            });

            if (babelHelpers.typeof(this.data.get('treeData')) === 'object') {
                this.data.set('treeData.checked', this.data.get('checked'));
                this.data.set('treeData.indeterminate', this.data.get('checkboxIndeterminate'));
            }

            this.updateSelfCheckboxStateFromChildren();

            this.dispatch('UI:tree-view-item-attached', this);
        },
        detached: function detached() {
            this.dispatch('UI:tree-view-item-detached', this);

            this.data.get('dataSource') !== 'JSON' && this.parentComponent && this.parentComponent.subTag === this.subTag && this.parentComponent.updateSelfCheckboxStateFromChildren();
        },
        created: function created() {},
        disposed: function disposed() {
            this.dispatch('UI:query-parent-checkbox-state');
        },
        updated: function updated() {},
        toggleTreeView: function toggleTreeView(evt, driver) {
            var forceOpen = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
            var forceSelected = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;

            evt.stopPropagation();

            if (this.data.get('disabled')) {
                return;
            }
            if (evt.target.tagName !== 'LABEL' && evt.target.tagName !== 'INPUT') {
                this.fire('click', { event: evt, comp: this });
            }

            (driver === 'EXPAND' || forceSelected) && this.toggleRipple();
            if (driver !== 'EXPAND' && !forceOpen && !this.data.get('primaryTogglesNestedTreeView') || evt && evt.target && (evt.target.tagName === 'INPUT' || evt.target.tagName === 'LABEL')) {
                return;
            }

            var open = this.data.get('open');
            this.data.set('open', forceOpen ? true : !open);

            this.fire('nestedTreeViewToggle', open);
            this.dispatch('UI:nested-item-toggle', this);
        },
        checkboxChanged: function checkboxChanged(evt) {
            evt.stopPropagation();

            var value = this.data.get('checkboxInputValue');
            var checked = value && value.toString() !== '';
            this.data.set('checked', checked);
            this.updateChildrenCheckboxState(checked, 'checkbox');

            this.fire('checkboxClick', { event: evt, comp: this.ref('checkbox'), checked: checked });
        },
        clearSelectedClass: function clearSelectedClass(send) {
            this.data.get('selected') === true && this.data.set('selected', false);
            send && this.dispatch('UI:clear-selected-item');
        },
        toggleRipple: function toggleRipple() {
            if (this.data.get('keepingSelected')) {
                if (this.data.get('selected') && !this.data.get('primaryTogglesNestedTreeView')) {
                    return;
                }
                this.clearSelectedClass(true);
                this.data.set('selected', true);
                this.dispatch('UI:record-selected-item');
            }
        },
        highlight: function highlight(word, input) {
            var backColor = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'coral';
            var foreColor = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 'white';

            var el = this.el;
            if (!el) {
                return;
            }
            var contentSelector = '.sm-tree-view-item-content';
            var primaryTextSelector = 'p.sm-tree-view-item-primary-text';
            var secondaryTextSelector = 'p.sm-tree-view-item-secondary-text';
            var primary = el.querySelector(contentSelector + '>' + primaryTextSelector);
            var secondary = el.querySelector(contentSelector + '>' + secondaryTextSelector);

            if (typeof word === 'string' && word !== '') {
                _highlight.Highlight.highlight(primary, word, input, backColor, foreColor);
                _highlight.Highlight.highlight(secondary, word, input, backColor, foreColor);
            } else {
                _highlight.Highlight.unhighlight(primary, input);
                _highlight.Highlight.unhighlight(secondary, input);
            }
        },
        updateChildrenCheckboxState: function updateChildrenCheckboxState(value, driver) {
            this.data.set('checkboxInputValue', value ? [this.data.get('checkboxValue')] : ['']);
            this.hasNestedSlotChildren() ? this.updateSlotChildrenCheckboxState(value) : this.updateJsonChildrenCheckboxState(value);
            if (driver === 'checkbox' && this.parentComponent && this.parentComponent.subTag === this.subTag) {
                this.parentComponent.updateSelfCheckboxStateFromChildren();
            }
        },
        hasNestedSlotChildren: function hasNestedSlotChildren() {
            var slotChildren = this.slotChildren;
            if (slotChildren.length <= 0) {
                return false;
            }
            var _iteratorNormalCompletion2 = true;
            var _didIteratorError2 = false;
            var _iteratorError2 = undefined;

            try {
                for (var _iterator2 = slotChildren[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
                    var i = _step2.value;

                    if (i.name !== 'nested') {
                        continue;
                    }
                    var _iteratorNormalCompletion3 = true;
                    var _didIteratorError3 = false;
                    var _iteratorError3 = undefined;

                    try {
                        for (var _iterator3 = i.children[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
                            var j = _step3.value;

                            if (j.subTag === this.subTag) {
                                return true;
                            }
                        }
                    } catch (err) {
                        _didIteratorError3 = true;
                        _iteratorError3 = err;
                    } finally {
                        try {
                            if (!_iteratorNormalCompletion3 && _iterator3.return) {
                                _iterator3.return();
                            }
                        } finally {
                            if (_didIteratorError3) {
                                throw _iteratorError3;
                            }
                        }
                    }
                }
            } catch (err) {
                _didIteratorError2 = true;
                _iteratorError2 = err;
            } finally {
                try {
                    if (!_iteratorNormalCompletion2 && _iterator2.return) {
                        _iterator2.return();
                    }
                } finally {
                    if (_didIteratorError2) {
                        throw _iteratorError2;
                    }
                }
            }

            return false;
        },
        getNestedAndCheckedSlotChildren: function getNestedAndCheckedSlotChildren() {
            var items = [];
            var slotChildren = this.slotChildren;
            if (!slotChildren || slotChildren && slotChildren.length <= 0) {
                return items;
            }
            var _iteratorNormalCompletion4 = true;
            var _didIteratorError4 = false;
            var _iteratorError4 = undefined;

            try {
                for (var _iterator4 = slotChildren[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
                    var i = _step4.value;

                    if (i.name !== 'nested') {
                        continue;
                    }
                    var _iteratorNormalCompletion5 = true;
                    var _didIteratorError5 = false;
                    var _iteratorError5 = undefined;

                    try {
                        for (var _iterator5 = i.children[Symbol.iterator](), _step5; !(_iteratorNormalCompletion5 = (_step5 = _iterator5.next()).done); _iteratorNormalCompletion5 = true) {
                            var j = _step5.value;

                            if (!j.el || !j.el.parentNode) {
                                continue;
                            }
                            if (j.subTag !== this.subTag || !j.owner) {
                                continue;
                            }
                            if (typeof j.data.get('checked') !== 'boolean') {
                                continue;
                            }
                            items.push(j);
                        }
                    } catch (err) {
                        _didIteratorError5 = true;
                        _iteratorError5 = err;
                    } finally {
                        try {
                            if (!_iteratorNormalCompletion5 && _iterator5.return) {
                                _iterator5.return();
                            }
                        } finally {
                            if (_didIteratorError5) {
                                throw _iteratorError5;
                            }
                        }
                    }
                }
            } catch (err) {
                _didIteratorError4 = true;
                _iteratorError4 = err;
            } finally {
                try {
                    if (!_iteratorNormalCompletion4 && _iterator4.return) {
                        _iterator4.return();
                    }
                } finally {
                    if (_didIteratorError4) {
                        throw _iteratorError4;
                    }
                }
            }

            return items;
        },
        getNestedAndCheckedJsonChildren: function getNestedAndCheckedJsonChildren() {
            var items = [];
            var treeData = this.data.get('treeData');
            if (!treeData || (typeof treeData === 'undefined' ? 'undefined' : babelHelpers.typeof(treeData)) !== 'object' || !(treeData.treeData instanceof Array)) {
                return items;
            }
            var count = treeData.treeData.length;
            if (count === 0) {
                return items;
            }
            for (var i = 0; i < count; i++) {
                var childComp = this.ref('item_' + i);
                if (!childComp || childComp.subTag !== this.subTag) {
                    continue;
                }
                if (typeof childComp.data.get('checked') !== 'boolean') {
                    continue;
                }
                items.push(childComp);
            }
            return items;
        },
        getParentHavingCheckbox: function getParentHavingCheckbox() {
            var parent = this.parentComponent;
            if (!parent || parent.subTag !== this.subTag) {
                return null;
            }
            var checked = parent.data.get('checked');
            if (typeof checked !== 'boolean') {
                return null;
            }
            return parent;
        },
        hasChildHavingCheckbox: function hasChildHavingCheckbox() {
            var children = this.getNestedAndCheckedSlotChildren();
            if (!children || children.length <= 0) {
                children = this.getNestedAndCheckedJsonChildren();
                if (!children || children.length <= 0) {
                    return false;
                }
            }
            var _iteratorNormalCompletion6 = true;
            var _didIteratorError6 = false;
            var _iteratorError6 = undefined;

            try {
                for (var _iterator6 = children[Symbol.iterator](), _step6; !(_iteratorNormalCompletion6 = (_step6 = _iterator6.next()).done); _iteratorNormalCompletion6 = true) {
                    var i = _step6.value;

                    if (typeof i.data.get('checked') === 'boolean') {
                        return true;
                    }
                }
            } catch (err) {
                _didIteratorError6 = true;
                _iteratorError6 = err;
            } finally {
                try {
                    if (!_iteratorNormalCompletion6 && _iterator6.return) {
                        _iterator6.return();
                    }
                } finally {
                    if (_didIteratorError6) {
                        throw _iteratorError6;
                    }
                }
            }

            return false;
        },
        updateSlotChildrenCheckboxState: function updateSlotChildrenCheckboxState(value) {
            var children = this.getNestedAndCheckedSlotChildren();
            var _iteratorNormalCompletion7 = true;
            var _didIteratorError7 = false;
            var _iteratorError7 = undefined;

            try {
                for (var _iterator7 = children[Symbol.iterator](), _step7; !(_iteratorNormalCompletion7 = (_step7 = _iterator7.next()).done); _iteratorNormalCompletion7 = true) {
                    var i = _step7.value;

                    i.data.set('checked', value);
                    i.updateChildrenCheckboxState(value);
                }
            } catch (err) {
                _didIteratorError7 = true;
                _iteratorError7 = err;
            } finally {
                try {
                    if (!_iteratorNormalCompletion7 && _iterator7.return) {
                        _iterator7.return();
                    }
                } finally {
                    if (_didIteratorError7) {
                        throw _iteratorError7;
                    }
                }
            }
        },
        updateJsonChildrenCheckboxState: function updateJsonChildrenCheckboxState(value) {
            var children = this.getNestedAndCheckedJsonChildren();
            var _iteratorNormalCompletion8 = true;
            var _didIteratorError8 = false;
            var _iteratorError8 = undefined;

            try {
                for (var _iterator8 = children[Symbol.iterator](), _step8; !(_iteratorNormalCompletion8 = (_step8 = _iterator8.next()).done); _iteratorNormalCompletion8 = true) {
                    var i = _step8.value;

                    i.data.set('checked', value);
                    i.updateChildrenCheckboxState(value);
                }
            } catch (err) {
                _didIteratorError8 = true;
                _iteratorError8 = err;
            } finally {
                try {
                    if (!_iteratorNormalCompletion8 && _iterator8.return) {
                        _iterator8.return();
                    }
                } finally {
                    if (_didIteratorError8) {
                        throw _iteratorError8;
                    }
                }
            }
        },
        updateSelfCheckboxStateFromChildren: function updateSelfCheckboxStateFromChildren() {
            var children = this.getNestedAndCheckedSlotChildren();
            if (!children || children.length <= 0) {
                children = this.getNestedAndCheckedJsonChildren();
                if (!children || children.length <= 0) {
                    this.data.set('checkboxIndeterminate', false);
                    return;
                }
            }
            if (this.data.get('checked') === null) {
                return;
            }
            var subChecked = void 0;
            var count = 0;
            var _iteratorNormalCompletion9 = true;
            var _didIteratorError9 = false;
            var _iteratorError9 = undefined;

            try {
                for (var _iterator9 = children[Symbol.iterator](), _step9; !(_iteratorNormalCompletion9 = (_step9 = _iterator9.next()).done); _iteratorNormalCompletion9 = true) {
                    var i = _step9.value;

                    var childChecked = i.data.get('checked');
                    if (typeof childChecked !== 'boolean') {
                        continue;
                    }
                    var childIndeterminate = i.data.get('checkboxIndeterminate');
                    if (childIndeterminate) {
                        this.data.set('checkboxIndeterminate', true);
                        if (this.data.get('checked') === undefined) {
                            this.data.set('checked', false);
                        }
                        return;
                    }
                    if (subChecked === undefined) {
                        subChecked = childChecked << count;
                    } else {
                        subChecked |= childChecked << count;
                    }
                    count++;
                }
            } catch (err) {
                _didIteratorError9 = true;
                _iteratorError9 = err;
            } finally {
                try {
                    if (!_iteratorNormalCompletion9 && _iterator9.return) {
                        _iterator9.return();
                    }
                } finally {
                    if (_didIteratorError9) {
                        throw _iteratorError9;
                    }
                }
            }

            if (subChecked !== undefined) {
                this.data.set('checked', subChecked === (1 << count) - 1);
                this.data.set('checkboxIndeterminate', subChecked > 0 && subChecked < (1 << count) - 1);
            }
            var parent = this.getParentHavingCheckbox();
            if (parent) {
                return parent.updateSelfCheckboxStateFromChildren();
            }
        },
        initFromTreeData: function initFromTreeData(data) {
            !data && (data = this.data.get('treeData'));
            if (!data || !(data instanceof Object)) {
                return;
            }
            this.data.set('toggleNested', !!data.treeData);
            this.data.set('primaryText', data.text);
            this.data.set('secondaryText', data.secondaryText);
            this.data.set('open', data.treeData && data.treeData.length > 0);
            var checked = data.checked;

            this.data.set('checked', checked);
            this.data.set('checkboxInputValue', checked ? [this.data.get('checkboxValue')] : [], {
                silence: true
            });
        },
        generateTreeData: function generateTreeData() {
            var data = {
                text: this.data.get('primaryText'),
                secondaryText: this.data.get('secondaryText'),
                checked: this.data.get('checked')
            };
            this.data.set('treeData', data, {
                silence: true
            });
            var checked = this.data.get('checked');
            this.data.set('checked', checked);
            this.data.set('checkboxInputValue', checked ? [this.data.get('checkboxValue')] : ['']);
        }
    });
});
//# sourceMappingURL=TreeViewItem.js.map
