(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../common/util/cx', '../Progress/index', '../Button/IconButton', './formatFileSize', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../common/util/cx'), require('../Progress/index'), require('../Button/IconButton'), require('./formatFileSize'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.cx, global.index, global.IconButton, global.formatFileSize, global.babelHelpers);
        global.FileItem = mod.exports;
    }
})(this, function (exports, _san, _cx, _index, _IconButton, _formatFileSize, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _IconButton2 = babelHelpers.interopRequireDefault(_IconButton);

    var _formatFileSize2 = babelHelpers.interopRequireDefault(_formatFileSize);

    var cx = (0, _cx.create)('file-item');

    var FileListItem = function (_Component) {
        babelHelpers.inherits(FileListItem, _Component);

        function FileListItem() {
            babelHelpers.classCallCheck(this, FileListItem);
            return babelHelpers.possibleConstructorReturn(this, (FileListItem.__proto__ || Object.getPrototypeOf(FileListItem)).apply(this, arguments));
        }

        babelHelpers.createClass(FileListItem, [{
            key: 'initData',
            value: function initData() {
                return {
                    status: 'uploaded',
                    disabled: false
                };
            }
        }, {
            key: 'remove',
            value: function remove() {
                this.fire('remove');
            }
        }]);
        return FileListItem;
    }(_san.Component);

    FileListItem.template = '\n        <div class="{{className}}">\n            <div class="' + cx.getPartClassName('name') + '" title="{{name}}">\n                {{name}}\n                <label s-if="status===\'error\'">{{errorMessage}}</label>\n            </div>\n            <div\n                s-if="size > 0"\n                class="' + cx.getPartClassName('size') + '">\n                {{formattedFileSize}}\n            </div>\n            <sm-icon-button\n                disabled="{{disabled}}"\n                variants="file-item danger"\n                on-click="remove">\n                clear\n            </sm-icon-button>\n            <sm-linear-progress\n                s-if="status === \'uploading\'"\n                mode="determinate"\n                value="{{progress}}" />\n        </div>\n    ';
    FileListItem.components = {
        'sm-linear-progress': _index.LinearProgress,
        'sm-icon-button': _IconButton2.default
    };
    FileListItem.computed = {
        className: function className() {
            var status = this.data.get('status');
            return cx(this).addStates(babelHelpers.defineProperty({}, status, true)).build();
        },
        formattedFileSize: function formattedFileSize() {
            var size = this.data.get('size');
            return size ? (0, _formatFileSize2.default)(this.data.get('size')) : '';
        }
    };
    FileListItem.dataTypes = {
        name: _san.DataTypes.string.isRequired,
        url: _san.DataTypes.string,
        status: _san.DataTypes.oneOf(['uploading', 'uploaded', 'error']).isRequired,
        progress: _san.DataTypes.number,
        size: _san.DataTypes.number,
        errorMessage: _san.DataTypes.string,
        disabled: _san.DataTypes.bool
    };
    exports.default = FileListItem;
});
//# sourceMappingURL=FileItem.js.map
