(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../common/util/cx', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../common/util/cx'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.cx, global.babelHelpers);
        global.FileList = mod.exports;
    }
})(this, function (exports, _san, _cx, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });


    var cx = (0, _cx.create)('file-list');

    var FileList = function (_Component) {
        babelHelpers.inherits(FileList, _Component);

        function FileList() {
            babelHelpers.classCallCheck(this, FileList);
            return babelHelpers.possibleConstructorReturn(this, (FileList.__proto__ || Object.getPrototypeOf(FileList)).apply(this, arguments));
        }

        return FileList;
    }(_san.Component);

    FileList.template = '\n        <div class="{{className}}">\n            <slot />\n        </div>\n    ';
    FileList.computed = {
        className: function className() {
            return cx(this).build();
        }
    };
    exports.default = FileList;
});
//# sourceMappingURL=FileList.js.map
