(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../Button/index', '../common/util/cx', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../Button/index'), require('../common/util/cx'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.index, global.cx, global.babelHelpers);
        global.FileSelector = mod.exports;
    }
})(this, function (exports, _san, _index, _cx, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _index2 = babelHelpers.interopRequireDefault(_index);

    var cx = (0, _cx.create)('file-selector');

    var FileSelector = function (_Component) {
        babelHelpers.inherits(FileSelector, _Component);

        function FileSelector() {
            babelHelpers.classCallCheck(this, FileSelector);
            return babelHelpers.possibleConstructorReturn(this, (FileSelector.__proto__ || Object.getPrototypeOf(FileSelector)).apply(this, arguments));
        }

        babelHelpers.createClass(FileSelector, [{
            key: 'initData',
            value: function initData() {
                return {
                    multiple: false,
                    accept: '*',
                    disabled: false
                };
            }
        }, {
            key: 'onReceiveFiles',
            value: function onReceiveFiles(e) {
                this.fire('select', e.target.files);
                this.el.value = '';
            }
        }, {
            key: 'onSelect',
            value: function onSelect() {
                if (this.data.get('duplicate')) {
                    this.el.lastElementChild.value = '';
                }
                this.el.lastElementChild.click();
            }
        }]);
        return FileSelector;
    }(_san.Component);

    FileSelector.template = '\n        <div class="{{className}}">\n            <a disabled="{{disabled}}" on-click="onSelect">\n                <slot name="inner-upload-btn"></slot>\n            </a>\n            <input\n                type="file"\n                style="display: none"\n                multiple="{{multiple ? \'multiple\' : \'\'}}"\n                accept="{{accept}}"\n                on-change="onReceiveFiles($event)"  />\n        </div>\n    ';
    FileSelector.computed = {
        className: function className() {
            return cx(this).build();
        }
    };
    FileSelector.dataTypes = {
        multiple: _san.DataTypes.bool,
        disabled: _san.DataTypes.bool,
        accept: _san.DataTypes.string,
        duplicate: _san.DataTypes.bool
    };
    FileSelector.components = {
        'sm-button': _index2.default
    };
    exports.default = FileSelector;
});
//# sourceMappingURL=FileSelector.js.map
