(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../Button/index', '../common/util/cx', './FileSelector', './FileList', './FileItem', './upload', '../common/util/guid', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../Button/index'), require('../common/util/cx'), require('./FileSelector'), require('./FileList'), require('./FileItem'), require('./upload'), require('../common/util/guid'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.index, global.cx, global.FileSelector, global.FileList, global.FileItem, global.upload, global.guid, global.babelHelpers);
        global.Uploader = mod.exports;
    }
})(this, function (exports, _san, _index, _cx, _FileSelector, _FileList, _FileItem, _upload, _guid, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _index2 = babelHelpers.interopRequireDefault(_index);

    var _FileSelector2 = babelHelpers.interopRequireDefault(_FileSelector);

    var _FileList2 = babelHelpers.interopRequireDefault(_FileList);

    var _FileItem2 = babelHelpers.interopRequireDefault(_FileItem);

    var _upload2 = babelHelpers.interopRequireDefault(_upload);

    var _guid2 = babelHelpers.interopRequireDefault(_guid);

    var ID_SYMBOL = Symbol();

    var cx = (0, _cx.create)('uploader');

    var Uploader = function (_Component) {
        babelHelpers.inherits(Uploader, _Component);

        function Uploader() {
            babelHelpers.classCallCheck(this, Uploader);
            return babelHelpers.possibleConstructorReturn(this, (Uploader.__proto__ || Object.getPrototypeOf(Uploader)).apply(this, arguments));
        }

        babelHelpers.createClass(Uploader, [{
            key: 'initData',
            value: function initData() {
                return {
                    mode: 'xhr',
                    headers: {},
                    multiple: false,
                    data: {},
                    name: 'file',
                    withCredentials: false,
                    autoUpload: true,
                    disabled: false,
                    json: false,
                    duplicate: false
                };
            }
        }, {
            key: 'inited',
            value: function inited() {
                var _data$get = this.data.get(),
                    files = _data$get.files,
                    extentions = _data$get.extentions;

                this.data.set('files', files.map(function (file) {
                    return babelHelpers.extends({}, file, babelHelpers.defineProperty({
                        status: 'uploaded'
                    }, ID_SYMBOL, (0, _guid2.default)()));
                }));

                if (typeof extentions === 'string') {
                    this.data.set('extentions', extentions.split(/\s*,\s*/));
                }
            }
        }, {
            key: 'addFiles',
            value: function addFiles(files) {
                var _iteratorNormalCompletion = true;
                var _didIteratorError = false;
                var _iteratorError = undefined;

                try {
                    for (var _iterator = files[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                        var file = _step.value;

                        this.uploadFile(file);
                    }
                } catch (err) {
                    _didIteratorError = true;
                    _iteratorError = err;
                } finally {
                    try {
                        if (!_iteratorNormalCompletion && _iterator.return) {
                            _iterator.return();
                        }
                    } finally {
                        if (_didIteratorError) {
                            throw _iteratorError;
                        }
                    }
                }
            }
        }, {
            key: 'isSameFile',
            value: function isSameFile(f1, f2) {
                return f1 === f2 || f1[ID_SYMBOL] === f2[ID_SYMBOL];
            }
        }, {
            key: 'uploadFile',
            value: function uploadFile(rawFile) {
                var _this2 = this;

                var plainFile = babelHelpers.defineProperty({
                    name: rawFile.name,
                    size: rawFile.size,
                    status: 'uploading'
                }, ID_SYMBOL, (0, _guid2.default)());

                var errorMessage = this.validateFile(plainFile);

                if (errorMessage) {
                    plainFile = babelHelpers.extends({}, plainFile, {
                        status: 'error',
                        errorMessage: errorMessage
                    });
                    this.data.push('files', plainFile);
                    return;
                }

                this.data.push('files', plainFile);

                var _data$get2 = this.data.get(),
                    _data$get2$upload = _data$get2.upload,
                    upload = _data$get2$upload === undefined ? _upload2.default : _data$get2$upload,
                    name = _data$get2.name,
                    action = _data$get2.action,
                    headers = _data$get2.headers,
                    data = _data$get2.data,
                    withCredentials = _data$get2.withCredentials;

                var createProtectedHandler = function createProtectedHandler(handler) {
                    return function () {
                        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                            args[_key] = arguments[_key];
                        }

                        if (!_this2.data) {
                            return;
                        }

                        var files = _this2.data.get('files');
                        for (var i = 0, len = files.length; i < len; i++) {
                            var file = files[i];
                            if (_this2.isSameFile(file, plainFile)) {
                                return handler.apply(undefined, [i, file].concat(args));
                            }
                        }
                    };
                };

                var progressHandler = createProtectedHandler(function (index, file, progress) {
                    var nextFile = babelHelpers.extends({}, file, { progress: progress });
                    _this2.data.set('files.' + index, babelHelpers.extends({}, file, { progress: progress }));
                    _this2.fire('progress', nextFile);
                });

                var uploadSuccessHandler = createProtectedHandler(function (index, file, result) {

                    if (typeof result === 'string') {
                        result = {
                            url: result
                        };
                    }

                    var nextFile = babelHelpers.extends({}, plainFile, result, {
                        status: 'uploaded'
                    });

                    _this2.data.set('files.' + index, nextFile);
                    _this2.fire('success', nextFile);
                });

                var uploadFailedHandler = createProtectedHandler(function (index, file, error) {

                    var nextFile = babelHelpers.extends({}, file, {
                        status: 'error',
                        error: error
                    });

                    _this2.data.set('files.' + index, nextFile);
                    _this2.fire('error', nextFile);
                });

                upload(rawFile, { name: name, action: action, headers: headers, withCredentials: withCredentials, data: data }, {
                    progress: progressHandler,
                    done: uploadSuccessHandler,
                    fail: uploadFailedHandler
                });
            }
        }, {
            key: 'removeFile',
            value: function removeFile(file) {
                this.data.set('files', this.data.get('files').filter(function (f) {
                    return f !== file;
                }));
                this.fire('remove', file);
            }
        }, {
            key: 'validateFile',
            value: function validateFile(file) {
                var validateFile = this.data.get('validateFile');
                return validateFile ? validateFile(file) : this.validateSize(file.size);
            }
        }, {
            key: 'validateSize',
            value: function validateSize(size) {
                var maxSize = this.data.get('maxSize') || 0;
                return !maxSize || size <= maxSize * 1024 * 1024 ? null : '\u6587\u4EF6\u5927\u5C0F\u4E0D\u5F97\u8D85\u8FC7' + maxSize + 'MB';
            }
        }]);
        return Uploader;
    }(_san.Component);

    Uploader.template = '\n        <div class="{{className}}">\n            <sm-file-selector\n                disabled="{{disabled}}"\n                accept="{{accept}}"\n                multiple="{{multiple}}"\n                duplicate="{{duplicate}}"\n                on-select="addFiles($event)">\n                <slot slot="inner-upload-btn"></slot>\n            </sm-file-selector>\n            <sm-file-list san-if="withFileList">\n                <sm-file-item\n                    s-for="file in files"\n                    disabled="{{disabled}}"\n                    name="{{file.name}}"\n                    size="{{file.size}}"\n                    status="{{file.status}}"\n                    url="{{file.url}}"\n                    progress="{{file.progress}}"\n                    errorMessage="{{file.errorMessage}}"\n                    on-remove="removeFile(file)" />\n            </sm-file-list>\n        </div>\n    ';
    Uploader.components = {
        'sm-button': _index2.default,
        'sm-file-selector': _FileSelector2.default,
        'sm-file-list': _FileList2.default,
        'sm-file-item': _FileItem2.default
    };
    Uploader.computed = {
        className: function className() {
            return cx(this).build();
        }
    };
    Uploader.dataTypes = {
        mode: _san.DataTypes.oneOf(['xhr']).isRequired,
        headers: _san.DataTypes.object,
        multiple: _san.DataTypes.bool.isRequired,
        name: _san.DataTypes.string.isRequired,
        withCredentials: _san.DataTypes.bool.isRequired,
        disabled: _san.DataTypes.bool.isRequired,
        withFileList: _san.DataTypes.bool,
        accept: _san.DataTypes.string,
        maxSize: _san.DataTypes.number,
        validateFile: _san.DataTypes.func,
        data: _san.DataTypes.object,
        json: _san.DataTypes.bool,
        upload: _san.DataTypes.func,
        duplicate: _san.DataTypes.bool
    };
    exports.default = Uploader;
});
//# sourceMappingURL=Uploader.js.map
