(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports);
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports);
        global.formatFileSize = mod.exports;
    }
})(this, function (exports) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    exports.default = function (size) {

        var unit = 0;

        while (size > 1024) {
            size /= 1024;
            unit++;
        }

        return '' + Math.ceil(size) + UNITS[unit];
    };

    var UNITS = ['B', 'KB', 'MB', 'GB', 'TB'];
});
//# sourceMappingURL=formatFileSize.js.map
