(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports);
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports);
        global.upload = mod.exports;
    }
})(this, function (exports) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.default = upload;
    function upload(file, options, _ref) {
        var progress = _ref.progress,
            done = _ref.done,
            fail = _ref.fail;
        var action = options.action,
            headers = options.headers,
            withCredentials = options.withCredentials,
            name = options.name,
            json = options.json,
            data = options.data;


        var xhr = file.xhr = new XMLHttpRequest();

        xhr.upload.onprogress = function (e) {
            var loaded = e.loaded,
                total = e.total;

            progress(Math.round(loaded / total * 100));
        };

        xhr.onload = function (e) {

            var data = xhr.responseText;
            var contentType = xhr.getResponseHeader('Content-Type');

            if (json || contentType && contentType.startsWith('application/json')) {
                try {
                    data = JSON.parse(data);
                } catch (e) {
                    fail(new Error('cannot parse response body to json'));
                    return;
                }
            }

            done(data);
        };

        xhr.onerror = function (e) {
            fail(e);
        };

        xhr.withCredentials = withCredentials;

        xhr.open('POST', action, true);

        if (headers) {
            Object.keys(headers).forEach(function (key) {
                return xhr.setRequestHeader(key, headers[key]);
            });
        }

        var formData = new FormData();

        formData.append(name, file);

        if (data) {
            Object.keys(data).forEach(function (key) {

                var item = data[key];

                if (!Array.isArray(item)) {
                    item = [item];
                }

                var _iteratorNormalCompletion = true;
                var _didIteratorError = false;
                var _iteratorError = undefined;

                try {
                    for (var _iterator = item[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                        var i = _step.value;

                        formData.append(key, i);
                    }
                } catch (err) {
                    _didIteratorError = true;
                    _iteratorError = err;
                } finally {
                    try {
                        if (!_iteratorNormalCompletion && _iterator.return) {
                            _iterator.return();
                        }
                    } finally {
                        if (_didIteratorError) {
                            throw _iteratorError;
                        }
                    }
                }
            });
        }

        xhr.send(formData);
    }
});
//# sourceMappingURL=upload.js.map
