(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports);
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports);
        global.css = mod.exports;
    }
})(this, function (exports) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.default = css;
    function css(style) {
        return style ? Object.keys(style).map(function (key) {
            var value = style[key];
            var kebabKey = key.replace(/([A-Z])/g, function (m) {
                return '-' + m.toLowerCase();
            });
            return value == null || value === '' ? '' : kebabKey + ':' + value + ';';
        }).join('') : '';
    }
});
//# sourceMappingURL=css.js.map
