(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'classnames', '../../constants', '../../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('classnames'), require('../../constants'), require('../../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.classnames, global.constants, global.babelHelpers);
        global.cx = mod.exports;
    }
})(this, function (exports, _classnames, _constants, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.create = create;

    var _classnames2 = babelHelpers.interopRequireDefault(_classnames);

    function addPrefix(prefix) {

        return function () {

            var classNames = _classnames2.default.apply(undefined, arguments).trim();

            return classNames ? classNames.split(' ').map(function (className) {
                return prefix + '-' + className;
            }).join(' ') : '';
        };
    }

    function resolveStates(component) {
        var disabled = component.data.get('disabled');
        var readOnly = component.data.get('readOnly');
        var hidden = component.data.get('hidden');
        return {
            disabled: disabled,
            readOnly: readOnly,
            hidden: hidden
        };
    }

    function convertToVariants(variants) {

        if (!variants) {
            return [];
        }

        if (typeof variants === 'string') {
            return variants.split(' ').filter(function (variant) {
                return !!variant;
            }).map(function (variant) {
                return variant.trim();
            });
        }

        return Array.isArray(variants) ? variants : [];
    }

    function create(prefix) {

        function getPartClassName(part) {
            return part ? _constants.COMPONENT_CLASSNAME_PREFIX + '-' + prefix + '-' + part : _constants.COMPONENT_CLASSNAME_PREFIX + '-' + prefix;
        }

        function classNameBuilder(component) {

            var part = '';
            var variants = convertToVariants(component.data.get('variants'));

            var states = resolveStates(component);
            var getVariantClassName = addPrefix('variant');
            var getStateClassName = addPrefix('state');

            var builder = {
                build: build,
                setPart: setPart,
                addVariants: addVariants,
                addStates: addStates
            };

            function setPart(p) {
                part = p;
                return builder;
            }

            function addVariants() {
                for (var _len = arguments.length, extraVariants = Array(_len), _key = 0; _key < _len; _key++) {
                    extraVariants[_key] = arguments[_key];
                }

                variants = [].concat(babelHelpers.toConsumableArray(variants), babelHelpers.toConsumableArray(extraVariants.map(convertToVariants)));
                return builder;
            }

            function addStates() {
                for (var _len2 = arguments.length, extraStates = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
                    extraStates[_key2] = arguments[_key2];
                }

                states = extraStates.reduce(function (states, state) {
                    return babelHelpers.extends({}, states, state);
                }, states);
                return builder;
            }

            function build() {
                return (0, _classnames2.default)(getPartClassName(part), getVariantClassName(variants), getStateClassName(states));
            }

            return builder;
        }

        classNameBuilder.getPartClassName = getPartClassName;

        return classNameBuilder;
    }
});
//# sourceMappingURL=cx.js.map
