export default function Parser<C extends CallbackHandlers | ProxyCallbackHandlers>(): Parser<CallbackHandlers>;
export default class Parser<C extends CallbackHandlers | ProxyCallbackHandlers> {
    on: <Handler extends keyof C>(name: Handler, cb: C[Handler]) => Parser<C>;
    proxy: () => Parser<ProxyCallbackHandlers>;
    ns: (nsMap?: NsMap) => Parser<any>;
    parse: (xml: string) => Error | null;
    stop: () => void;
}
export type NsMap = {
    [x: string]: string;
};
export type NsMatrix = {
    [x: string]: string;
};
export type AttributeMap = {
    [x: string]: string;
};
export type ParseContext = {
    data: string;
    line: number;
    column: number;
};
export type ContextGetter = () => ParseContext;
export type AttributeGetter = () => AttributeMap;
export type ElementProxy = {
    name: string;
    originalName: string;
    attrs: AttributeMap;
    ns: NsMatrix;
};
export type ErrorHandler = (error: Error, getContext?: ContextGetter) => void;
export type StringHandler = (text: string, getContext?: ContextGetter) => void;
export type DecodeableStringHandler = (text: string, decode?: typeof decodeEntities, getContext?: ContextGetter) => void;
export type TextHandler = DecodeableStringHandler;
export type ProxyOpenTagHandler = (elementProxy: ElementProxy, decode?: typeof decodeEntities, selfClosing?: boolean, getContext?: ContextGetter) => void;
export type OpenTagHandler = (elementName: string, getAttrs?: AttributeGetter, decode?: typeof decodeEntities, selfClosing?: boolean, getContext?: ContextGetter) => void;
export type CDATAHandler = StringHandler;
export type QuestionHandler = StringHandler;
export type AttentionHandler = DecodeableStringHandler;
export type ProxyCloseTagHandler = (elementProxy: ElementProxy, decode?: typeof decodeEntities, selfClosing?: boolean, getContext?: ContextGetter) => void;
export type CloseTagHandler = (elementName: string, decode?: typeof decodeEntities, selfClosing?: boolean, getContext?: ContextGetter) => void;
export type CallbackHandlers = {
    openTag: OpenTagHandler;
    closeTag: CloseTagHandler;
    text: TextHandler;
    cdata: CDATAHandler;
    error: ErrorHandler;
    warning: ErrorHandler;
    question: QuestionHandler;
    attention: AttentionHandler;
};
export type ProxyCallbackHandlers = {
    openTag: ProxyOpenTagHandler;
    closeTag: ProxyCloseTagHandler;
    text: TextHandler;
    cdata: CDATAHandler;
    error: ErrorHandler;
    warning: ErrorHandler;
    question: QuestionHandler;
    attention: AttentionHandler;
};
import decodeEntities from "./decode";
declare function error(msg: any): Error;
export {};
