'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
function promisify(callback) {
  var throwError = arguments.length <= 1 || arguments[1] === undefined ? true : arguments[1];

  return function promisified() {
    var _this = this;

    for (var _len = arguments.length, parameters = Array(_len), _key = 0; _key < _len; _key++) {
      parameters[_key] = arguments[_key];
    }

    var promise = new Promise(function (resolve, reject) {
      parameters.push(function (error, data) {
        if (error) {
          reject(error);
        } else resolve(data);
      });
      callback.apply(_this, parameters);
    });
    if (!throwError) {
      promise = promise.then(function (result) {
        return typeof result === 'undefined' ? true : result;
      }).catch(function () {
        return false;
      });
    }
    return promise;
  };
}

function promisifyAll(object) {
  var throwError = arguments.length <= 1 || arguments[1] === undefined ? true : arguments[1];

  var duplicate = Object.assign({}, object);
  for (var item in duplicate) {
    if (!{}.hasOwnProperty.call(duplicate, item) || typeof duplicate[item] !== 'function') {
      continue;
    }
    duplicate[item + 'Async'] = promisify(duplicate[item], throwError);
  }
  return duplicate;
}

exports.default = promisify;
exports.promisify = promisify;
exports.promisifyAll = promisifyAll;