import { defineComponent as _, ref as p, computed as N, openBlock as u, createBlock as c, withCtx as l, createVNode as d, unref as n, createElementVNode as f, normalizeClass as P, toDisplayString as B, createTextVNode as L } from "vue";
import { ScalarListbox as M, ScalarButton as b, ScalarIcon as T } from "@scalar/components";
import { useToasts as j } from "@scalar/use-toasts";
import { useActiveEntities as z } from "../../store/active-entities.js";
import E from "./CommandActionForm.vue.js";
import R from "./CommandActionInput.vue.js";
import { useWorkspace as W } from "../../store/store.js";
const G = /* @__PURE__ */ _({
  __name: "CommandPaletteServer",
  props: {
    metaData: {}
  },
  emits: ["close", "back"],
  setup(C, { emit: x }) {
    const s = C, m = x, { toast: v } = j(), { activeCollection: S, activeWorkspaceCollections: k } = z(), {
      collectionMutators: V,
      serverMutators: g,
      events: D,
      collections: U
    } = W(), r = p(""), i = N(
      () => k.value.flatMap(
        (o) => {
          var e, t;
          return ((e = o.info) == null ? void 0 : e.title) === "Drafts" ? [] : {
            id: o.uid,
            label: ((t = o.info) == null ? void 0 : t.title) ?? "Unititled Collection"
          };
        }
      )
    ), a = p(
      s.metaData ? i.value.find(
        (o) => {
          var e, t;
          return o.id === ((e = s.metaData) == null ? void 0 : e.itemUid) || o.id === ((t = s.metaData) == null ? void 0 : t.parentUid);
        }
      ) : i.value.find(
        (o) => {
          var e;
          return o.id === ((e = S.value) == null ? void 0 : e.uid);
        }
      )
    ), w = () => {
      var t;
      if (!r.value.trim()) {
        v("Please enter a valid url before creating a server.", "error");
        return;
      }
      const o = U[((t = a.value) == null ? void 0 : t.id) ?? ""];
      if (!o) {
        v("Please select a collection before creating a server.", "error");
        return;
      }
      const e = g.add({ url: r.value }, o.uid);
      V.edit(o.uid, "selectedServerUid", e.uid), m("close");
    }, y = () => {
      D.commandPalette.emit({ commandName: "Create Collection" });
    };
    return (o, e) => (u(), c(E, {
      disabled: !r.value.trim() || !a.value,
      onSubmit: w
    }, {
      options: l(() => [
        d(n(M), {
          modelValue: a.value,
          "onUpdate:modelValue": e[2] || (e[2] = (t) => a.value = t),
          options: i.value
        }, {
          default: l(() => [
            i.value.length > 0 ? (u(), c(n(b), {
              key: 0,
              class: "hover:bg-b-2 max-h-8 w-fit justify-between gap-1 p-2 text-xs",
              variant: "outlined"
            }, {
              default: l(() => [
                f("span", {
                  class: P(a.value ? "text-c-1" : "text-c-3")
                }, B(a.value ? a.value.label : "Select Collection"), 3),
                d(n(T), {
                  class: "text-c-3",
                  icon: "ChevronDown",
                  size: "md"
                })
              ]),
              _: 1
            })) : (u(), c(n(b), {
              key: 1,
              class: "hover:bg-b-2 max-h-8 w-fit justify-between gap-1 p-2 text-xs",
              variant: "outlined",
              onClick: y
            }, {
              default: l(() => e[3] || (e[3] = [
                f("span", { class: "text-c-1" }, "Create Collection", -1)
              ])),
              _: 1
            }))
          ]),
          _: 1
        }, 8, ["modelValue", "options"])
      ]),
      submit: l(() => e[4] || (e[4] = [
        L(" Create Server ")
      ])),
      default: l(() => [
        d(R, {
          modelValue: r.value,
          "onUpdate:modelValue": e[0] || (e[0] = (t) => r.value = t),
          label: "Server URL",
          placeholder: "Server URL",
          onOnDelete: e[1] || (e[1] = (t) => m("back", t))
        }, null, 8, ["modelValue"])
      ]),
      _: 1
    }, 8, ["disabled"]));
  }
});
export {
  G as default
};
