import { defineComponent as L, computed as i, watch as W, openBlock as n, createBlock as c, unref as a, withCtx as u, createElementVNode as s, normalizeClass as h, createElementBlock as d, Fragment as m, renderList as k, createVNode as v, createCommentVNode as f, createTextVNode as j, toDisplayString as q } from "vue";
import { cva as E, ScalarPopover as F, ScalarDropdownDivider as I, ScalarIcon as x, ScalarFloatingBackdrop as M, ScalarButton as P, cx as T } from "@scalar/components";
import { useLayout as $ } from "../../hooks/useLayout.js";
import { useWorkspace as G } from "../../store/store.js";
import w from "./ServerDropdownItem.vue.js";
const H = ["onClick"], J = { class: "flex h-4 w-4 items-center justify-center" }, Z = /* @__PURE__ */ L({
  __name: "ServerDropdown",
  props: {
    collection: {},
    operation: {},
    server: {},
    layout: {},
    target: {}
  },
  setup(l) {
    const { layout: C } = $(), { servers: p, collectionMutators: D, events: U, serverMutators: V } = G(), y = i(
      () => {
        var e, r;
        return (r = (e = l.operation) == null ? void 0 : e.servers) == null ? void 0 : r.map((t) => {
          var o;
          return {
            id: t,
            label: ((o = p[t]) == null ? void 0 : o.url) ?? "Unknown server"
          };
        });
      }
    ), b = i(
      () => {
        var e, r;
        return (
          // Filters out servers already present in the request
          (r = (e = l.collection) == null ? void 0 : e.servers) == null ? void 0 : r.filter((t) => {
            var o, S;
            return !((S = (o = l.operation) == null ? void 0 : o.servers) != null && S.includes(t));
          }).map((t) => {
            var o;
            return {
              id: t,
              label: ((o = p[t]) == null ? void 0 : o.url) ?? "Unknown server"
            };
          })
        );
      }
    ), z = i(
      () => {
        var e, r;
        return ((e = y.value) == null ? void 0 : e.length) && ((r = b.value) == null ? void 0 : r.length);
      }
    );
    W([() => l.collection, () => l.operation], ([e, r]) => {
      var o;
      if (!e || e.selectedServerUid || r != null && r.selectedServerUid)
        return;
      const t = (o = l.collection.servers) == null ? void 0 : o[0];
      t && D.edit(l.collection.uid, "selectedServerUid", t);
    });
    const B = () => U.commandPalette.emit({
      commandName: "Add Server"
    }), N = i(() => {
      var e, r, t;
      return (r = (e = l.server) == null ? void 0 : e.url) != null && r.endsWith("/") ? l.server.url.slice(0, -1) : ((t = l.server) == null ? void 0 : t.url) || "";
    }), g = (e, r) => {
      if (!l.server) return;
      const t = l.server.variables || {};
      t[e] = { ...t[e], default: r }, V.edit(l.server.uid, "variables", t);
    }, A = E({
      base: "gap-0.75 z-context-plus lg:text-sm text-xs whitespace-nowrap px-1.5 h-6.5",
      variants: {
        reference: {
          true: "!font-normal justify-start px-3 py-1.5 rounded-b-lg text-c-1 w-full",
          false: "border hover:bg-b-2 font-code ml-0.75 rounded text-c-2"
        }
      }
    });
    return (e, r) => (n(), c(a(F), {
      class: "max-h-[inherit] p-0 text-sm",
      offset: e.layout === "reference" ? 6 : 0,
      placement: "bottom-start",
      resize: "",
      target: e.target,
      teleport: `#${e.target}`
    }, {
      popover: u(({ close: t }) => [
        s("div", {
          class: h(["custom-scroll flex max-h-[inherit] flex-col gap-1 p-1", e.layout !== "reference" && "border-t"]),
          onClick: t
        }, [
          (n(!0), d(m, null, k(y.value, (o) => (n(), c(w, {
            key: o.id,
            collection: e.collection,
            layout: e.layout,
            operation: e.operation,
            server: e.server,
            serverOption: o,
            type: "request",
            "onUpdate:variable": g
          }, null, 8, ["collection", "layout", "operation", "server", "serverOption"]))), 128)),
          z.value ? (n(), d(m, { key: 0 }, [
            v(a(I)),
            r[1] || (r[1] = s("div", { class: "text-xxs text-c-2 px-2.5 py-1" }, "Collection", -1))
          ], 64)) : f("", !0),
          (n(!0), d(m, null, k(b.value, (o) => (n(), c(w, {
            key: o.id,
            collection: e.collection,
            layout: e.layout,
            operation: e.operation,
            server: e.server,
            serverOption: o,
            type: "collection",
            "onUpdate:variable": g
          }, null, 8, ["collection", "layout", "operation", "server", "serverOption"]))), 128)),
          a(C) !== "modal" ? (n(), d("button", {
            key: 1,
            class: "text-xxs p-1.75 hover:bg-b-2 flex cursor-pointer items-center gap-1.5 rounded",
            type: "button",
            onClick: B
          }, [
            s("div", J, [
              v(a(x), {
                icon: "Add",
                size: "sm"
              })
            ]),
            r[2] || (r[2] = s("span", null, "Add Server", -1))
          ])) : f("", !0)
        ], 10, H)
      ]),
      backdrop: u(() => [
        v(a(M), { class: "-top-[--scalar-address-bar-height] rounded-lg" })
      ]),
      default: u(() => [
        v(a(P), {
          class: h(a(T)(a(A)({ reference: e.layout === "reference" }))),
          variant: "ghost"
        }, {
          default: u(() => [
            r[0] || (r[0] = s("span", { class: "sr-only" }, "Server:", -1)),
            j(" " + q(N.value) + " ", 1),
            e.layout === "reference" ? (n(), c(a(x), {
              key: 0,
              class: "text-c-2",
              icon: "ChevronDown",
              size: "sm"
            })) : f("", !0)
          ]),
          _: 1
        }, 8, ["class"])
      ]),
      _: 1
    }, 8, ["offset", "target", "teleport"]));
  }
});
export {
  Z as default
};
