import MimeType from 'whatwg-mimetype';
/**
 * Processes the response body of an HTTP request.
 * Extracts MIME type, attachment filename, and generates a data URL.
 */
export declare function useResponseBody(props: {
    data: unknown;
    headers: {
        name: string;
        value: string;
        required: boolean;
    }[];
}): {
    mimeType: import("vue").ComputedRef<MimeType>;
    attachmentFilename: import("vue").ComputedRef<string>;
    dataUrl: import("vue").ComputedRef<string>;
};
//# sourceMappingURL=useResponseBody.d.ts.map