import type { Request } from '@scalar/oas-utils/entities/spec';
/** Convert path string like '/planets/{planetId}' to regex pattern /\/planets/([^/]+)/ */
export declare const pathToRegex: (path: string) => RegExp;
/**
 * Takes a path and method and returns the request that matches the path and method while taking
 * path params into account by converting to a regex. Will also return the path params if they exist
 *
 * @example path can be /planets/{planetId} OR /planets/1
 */
export declare const findRequestByPathMethod: (path: string, method: string, requests: Request[]) => {
    request: {
        path: string;
        type: "request";
        uid: string & import("zod").BRAND<"operation">;
        selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
        selectedServerUid: (string & import("zod").BRAND<"server">) | null;
        servers: (string & import("zod").BRAND<"server">)[];
        examples: (string & import("zod").BRAND<"example">)[];
        method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
        description?: string | undefined;
        summary?: string | undefined;
        externalDocs?: {
            url: string;
            description?: string | undefined;
        } | undefined;
        'x-internal'?: boolean | undefined;
        'x-scalar-ignore'?: boolean | undefined;
        security?: Record<string, string[]>[] | undefined;
        tags?: string[] | undefined;
        deprecated?: boolean | undefined;
        operationId?: string | undefined;
        parameters?: {
            required: boolean;
            name: string;
            in: "path" | "cookie" | "query" | "header";
            deprecated: boolean;
            example?: unknown;
            description?: string | undefined;
            schema?: unknown;
            content?: unknown;
            style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
            examples?: Record<string, {
                value?: unknown;
                summary?: string | undefined;
            }> | undefined;
        }[] | undefined;
        requestBody?: any;
        responses?: Record<string, any> | undefined;
    } | undefined;
    pathParams: {
        key: string;
        value: string;
    }[];
};
//# sourceMappingURL=find-request.d.ts.map