import type { RouteLocationNormalized } from 'vue-router';
export declare enum PathId {
    Request = "request",
    Examples = "examples",
    Cookies = "cookies",
    Collection = "collection",
    Schema = "schema",
    Environment = "environment",
    Servers = "servers",
    Workspace = "workspace",
    Settings = "settings"
}
/** Save the active workspace in localStorage for when the client reloads */
export declare function saveActiveWorkspace(to: RouteLocationNormalized): void;
/** Redirect to the saved workspace or the default workspace */
export declare function redirectToActiveWorkspace(): {
    name: string;
    params?: never;
} | {
    name: string;
    params: {
        workspace: string;
    };
};
/** Routes required by the API client modal */
export declare const modalRoutes: ({
    name: string;
    path: string;
    redirect: typeof redirectToActiveWorkspace;
    children?: never;
} | {
    name: string;
    path: string;
    redirect: {
        name: string;
        params: {
            workspace: string;
        };
    };
    children?: never;
} | {
    name: string;
    path: string;
    redirect: {
        name: string;
        params?: never;
    };
    children: ({
        name: string;
        path: string;
        redirect: (to: import("vue-router").RouteLocation) => {
            name: string;
            params: {
                request: string;
            };
        };
        component?: never;
    } | {
        name: string;
        path: string;
        component: () => Promise<typeof import("./views/Request/Request.vue")>;
        redirect?: never;
    })[];
})[];
/** Routes for the API client app */
export declare const routes: ({
    name: string;
    path: string;
    redirect: typeof redirectToActiveWorkspace;
    children?: never;
} | {
    name: string;
    path: string;
    redirect: {
        name: string;
        params: {
            workspace: string;
        };
    };
    children?: never;
} | {
    name: string;
    path: string;
    redirect: {
        name: string;
        params?: never;
    };
    children: ({
        name: string;
        path: string;
        redirect: (to: import("vue-router").RouteLocation) => {
            name: string;
            params: {
                request: string;
            };
        };
        component?: never;
    } | {
        name: string;
        path: string;
        component: () => Promise<typeof import("./views/Request/Request.vue")>;
        redirect?: never;
    } | {
        name: string;
        path: string;
        redirect: (to: import("vue-router").RouteLocation) => {
            name: string;
            params: {
                environment: string;
            };
        };
        component?: never;
        props?: never;
    } | {
        name: string;
        path: string;
        component: () => Promise<typeof import("./views/Environment/Environment.vue")>;
        redirect?: never;
        props?: never;
    } | {
        name: string;
        path: string;
        component: () => Promise<typeof import("./views/Environment/Environment.vue")>;
        props: true;
        redirect?: never;
    } | {
        name: string;
        path: string;
        redirect: (to: import("vue-router").RouteLocation) => {
            name: string;
            params: {
                cookies: string;
            };
        };
        component?: never;
        props?: never;
    } | {
        name: string;
        path: string;
        redirect: (to: import("vue-router").RouteLocation) => {
            name: string;
            params: {
                collection: string;
                servers: string;
            };
        };
        component?: never;
        props?: never;
    } | {
        name: string;
        path: string;
        redirect: (to: import("vue-router").RouteLocation) => {
            name: string;
            params: {
                settings: string;
            };
        };
        component?: never;
        props?: never;
    })[];
})[];
//# sourceMappingURL=routes.d.ts.map