import type { StoreContext } from '../store/store-context';
import { type Collection, type CollectionPayload, type XScalarEnvironment } from '@scalar/oas-utils/entities/spec';
import type { Workspace } from '@scalar/oas-utils/entities/workspace';
/** Initiate the workspace collections */
export declare function createStoreCollections(useLocalStorage: boolean): {
    collections: Record<string, {
        type: "collection";
        uid: string & import("zod").BRAND<"collection">;
        children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
        openapi: string;
        security: Record<string, string[]>[];
        'x-scalar-icon': string;
        securitySchemes: string[];
        selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
        servers: (string & import("zod").BRAND<"server">)[];
        requests: (string & import("zod").BRAND<"operation">)[];
        tags: (string & import("zod").BRAND<"tag">)[];
        watchMode: boolean;
        watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
        externalDocs?: {
            url: string;
            description?: string | undefined;
        } | undefined;
        jsonSchemaDialect?: string | undefined;
        info?: {
            title: string;
            version: string;
            description?: string | undefined;
            summary?: string | undefined;
            termsOfService?: string | undefined;
            contact?: {
                name?: string | undefined;
                url?: string | undefined;
                email?: string | undefined;
            } | undefined;
            license?: {
                name: string;
                identifier?: string | undefined;
                url?: string | undefined;
            } | undefined;
        } | undefined;
        components?: Record<string, unknown> | undefined;
        webhooks?: Record<string, unknown> | undefined;
        'x-scalar-active-environment'?: string | undefined;
        'x-scalar-environments'?: Record<string, {
            variables: Record<string, string | {
                default: string;
                description?: string | undefined;
            }>;
            description?: string | undefined;
            color?: string | undefined;
        }> | undefined;
        'x-scalar-secrets'?: Record<string, {
            example?: string | undefined;
            description?: string | undefined;
        }> | undefined;
        selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
        documentUrl?: string | undefined;
        integration?: string | null | undefined;
    }>;
    collectionMutators: {
        add: (item: {
            type: "collection";
            uid: string & import("zod").BRAND<"collection">;
            children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
            openapi: string;
            security: Record<string, string[]>[];
            'x-scalar-icon': string;
            securitySchemes: string[];
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            servers: (string & import("zod").BRAND<"server">)[];
            requests: (string & import("zod").BRAND<"operation">)[];
            tags: (string & import("zod").BRAND<"tag">)[];
            watchMode: boolean;
            watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            jsonSchemaDialect?: string | undefined;
            info?: {
                title: string;
                version: string;
                description?: string | undefined;
                summary?: string | undefined;
                termsOfService?: string | undefined;
                contact?: {
                    name?: string | undefined;
                    url?: string | undefined;
                    email?: string | undefined;
                } | undefined;
                license?: {
                    name: string;
                    identifier?: string | undefined;
                    url?: string | undefined;
                } | undefined;
            } | undefined;
            components?: Record<string, unknown> | undefined;
            webhooks?: Record<string, unknown> | undefined;
            'x-scalar-active-environment'?: string | undefined;
            'x-scalar-environments'?: Record<string, {
                variables: Record<string, string | {
                    default: string;
                    description?: string | undefined;
                }>;
                description?: string | undefined;
                color?: string | undefined;
            }> | undefined;
            'x-scalar-secrets'?: Record<string, {
                example?: string | undefined;
                description?: string | undefined;
            }> | undefined;
            selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
            documentUrl?: string | undefined;
            integration?: string | null | undefined;
        }) => void;
        delete: (uid: (string & import("zod").BRAND<"collection">) | null | undefined) => void;
        set: (item: {
            type: "collection";
            uid: string & import("zod").BRAND<"collection">;
            children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
            openapi: string;
            security: Record<string, string[]>[];
            'x-scalar-icon': string;
            securitySchemes: string[];
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            servers: (string & import("zod").BRAND<"server">)[];
            requests: (string & import("zod").BRAND<"operation">)[];
            tags: (string & import("zod").BRAND<"tag">)[];
            watchMode: boolean;
            watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            jsonSchemaDialect?: string | undefined;
            info?: {
                title: string;
                version: string;
                description?: string | undefined;
                summary?: string | undefined;
                termsOfService?: string | undefined;
                contact?: {
                    name?: string | undefined;
                    url?: string | undefined;
                    email?: string | undefined;
                } | undefined;
                license?: {
                    name: string;
                    identifier?: string | undefined;
                    url?: string | undefined;
                } | undefined;
            } | undefined;
            components?: Record<string, unknown> | undefined;
            webhooks?: Record<string, unknown> | undefined;
            'x-scalar-active-environment'?: string | undefined;
            'x-scalar-environments'?: Record<string, {
                variables: Record<string, string | {
                    default: string;
                    description?: string | undefined;
                }>;
                description?: string | undefined;
                color?: string | undefined;
            }> | undefined;
            'x-scalar-secrets'?: Record<string, {
                example?: string | undefined;
                description?: string | undefined;
            }> | undefined;
            selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
            documentUrl?: string | undefined;
            integration?: string | null | undefined;
        }) => void;
        edit: <P extends "servers" | "tags" | "security" | "externalDocs" | "type" | "uid" | "requests" | "x-scalar-environments" | "children" | "openapi" | "x-scalar-icon" | "securitySchemes" | "selectedSecuritySchemeUids" | "watchMode" | "watchModeStatus" | "jsonSchemaDialect" | "info" | "components" | "webhooks" | "x-scalar-active-environment" | "x-scalar-secrets" | "selectedServerUid" | "documentUrl" | "integration" | `servers.${number}` | `tags.${number}` | `security.${number}` | `security.${number}.${string}` | "externalDocs.description" | "externalDocs.url" | `requests.${number}` | `x-scalar-environments.${string}` | `children.${number}` | `securitySchemes.${number}` | `selectedSecuritySchemeUids.${number}` | `selectedSecuritySchemeUids.${number}.${number}` | "info.summary" | "info.description" | "info.title" | "info.version" | "info.termsOfService" | "info.contact" | "info.license" | "info.contact.name" | "info.contact.url" | "info.contact.email" | "info.license.name" | "info.license.url" | "info.license.identifier" | `components.${string}` | `webhooks.${string}` | `x-scalar-secrets.${string}`>(uid: (string & import("zod").BRAND<"collection">) | null | undefined, path: P, value: P extends "servers" | "tags" | "security" | "externalDocs" | "type" | "uid" | "requests" | "x-scalar-environments" | "children" | "openapi" | "x-scalar-icon" | "securitySchemes" | "selectedSecuritySchemeUids" | "watchMode" | "watchModeStatus" | "jsonSchemaDialect" | "info" | "components" | "webhooks" | "x-scalar-active-environment" | "x-scalar-secrets" | "selectedServerUid" | "documentUrl" | "integration" ? {
            type: "collection";
            uid: string & import("zod").BRAND<"collection">;
            children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
            openapi: string;
            security: Record<string, string[]>[];
            'x-scalar-icon': string;
            securitySchemes: string[];
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            servers: (string & import("zod").BRAND<"server">)[];
            requests: (string & import("zod").BRAND<"operation">)[];
            tags: (string & import("zod").BRAND<"tag">)[];
            watchMode: boolean;
            watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            jsonSchemaDialect?: string | undefined;
            info?: {
                title: string;
                version: string;
                description?: string | undefined;
                summary?: string | undefined;
                termsOfService?: string | undefined;
                contact?: {
                    name?: string | undefined;
                    url?: string | undefined;
                    email?: string | undefined;
                } | undefined;
                license?: {
                    name: string;
                    identifier?: string | undefined;
                    url?: string | undefined;
                } | undefined;
            } | undefined;
            components?: Record<string, unknown> | undefined;
            webhooks?: Record<string, unknown> | undefined;
            'x-scalar-active-environment'?: string | undefined;
            'x-scalar-environments'?: Record<string, {
                variables: Record<string, string | {
                    default: string;
                    description?: string | undefined;
                }>;
                description?: string | undefined;
                color?: string | undefined;
            }> | undefined;
            'x-scalar-secrets'?: Record<string, {
                example?: string | undefined;
                description?: string | undefined;
            }> | undefined;
            selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
            documentUrl?: string | undefined;
            integration?: string | null | undefined;
        }[P] : P extends `${infer K}.${infer R}` ? K extends "servers" | "tags" | "security" | "externalDocs" | "type" | "uid" | "requests" | "x-scalar-environments" | "children" | "openapi" | "x-scalar-icon" | "securitySchemes" | "selectedSecuritySchemeUids" | "watchMode" | "watchModeStatus" | "jsonSchemaDialect" | "info" | "components" | "webhooks" | "x-scalar-active-environment" | "x-scalar-secrets" | "selectedServerUid" | "documentUrl" | "integration" ? R extends import("@scalar/object-utils/nested").Path<{
            type: "collection";
            uid: string & import("zod").BRAND<"collection">;
            children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
            openapi: string;
            security: Record<string, string[]>[];
            'x-scalar-icon': string;
            securitySchemes: string[];
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            servers: (string & import("zod").BRAND<"server">)[];
            requests: (string & import("zod").BRAND<"operation">)[];
            tags: (string & import("zod").BRAND<"tag">)[];
            watchMode: boolean;
            watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            jsonSchemaDialect?: string | undefined;
            info?: {
                title: string;
                version: string;
                description?: string | undefined;
                summary?: string | undefined;
                termsOfService?: string | undefined;
                contact?: {
                    name?: string | undefined;
                    url?: string | undefined;
                    email?: string | undefined;
                } | undefined;
                license?: {
                    name: string;
                    identifier?: string | undefined;
                    url?: string | undefined;
                } | undefined;
            } | undefined;
            components?: Record<string, unknown> | undefined;
            webhooks?: Record<string, unknown> | undefined;
            'x-scalar-active-environment'?: string | undefined;
            'x-scalar-environments'?: Record<string, {
                variables: Record<string, string | {
                    default: string;
                    description?: string | undefined;
                }>;
                description?: string | undefined;
                color?: string | undefined;
            }> | undefined;
            'x-scalar-secrets'?: Record<string, {
                example?: string | undefined;
                description?: string | undefined;
            }> | undefined;
            selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
            documentUrl?: string | undefined;
            integration?: string | null | undefined;
        }[K]> ? import("@scalar/object-utils/nested").PathValue<{
            type: "collection";
            uid: string & import("zod").BRAND<"collection">;
            children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
            openapi: string;
            security: Record<string, string[]>[];
            'x-scalar-icon': string;
            securitySchemes: string[];
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            servers: (string & import("zod").BRAND<"server">)[];
            requests: (string & import("zod").BRAND<"operation">)[];
            tags: (string & import("zod").BRAND<"tag">)[];
            watchMode: boolean;
            watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            jsonSchemaDialect?: string | undefined;
            info?: {
                title: string;
                version: string;
                description?: string | undefined;
                summary?: string | undefined;
                termsOfService?: string | undefined;
                contact?: {
                    name?: string | undefined;
                    url?: string | undefined;
                    email?: string | undefined;
                } | undefined;
                license?: {
                    name: string;
                    identifier?: string | undefined;
                    url?: string | undefined;
                } | undefined;
            } | undefined;
            components?: Record<string, unknown> | undefined;
            webhooks?: Record<string, unknown> | undefined;
            'x-scalar-active-environment'?: string | undefined;
            'x-scalar-environments'?: Record<string, {
                variables: Record<string, string | {
                    default: string;
                    description?: string | undefined;
                }>;
                description?: string | undefined;
                color?: string | undefined;
            }> | undefined;
            'x-scalar-secrets'?: Record<string, {
                example?: string | undefined;
                description?: string | undefined;
            }> | undefined;
            selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
            documentUrl?: string | undefined;
            integration?: string | null | undefined;
        }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
        untrackedEdit: <P extends "servers" | "tags" | "security" | "externalDocs" | "type" | "uid" | "requests" | "x-scalar-environments" | "children" | "openapi" | "x-scalar-icon" | "securitySchemes" | "selectedSecuritySchemeUids" | "watchMode" | "watchModeStatus" | "jsonSchemaDialect" | "info" | "components" | "webhooks" | "x-scalar-active-environment" | "x-scalar-secrets" | "selectedServerUid" | "documentUrl" | "integration" | `servers.${number}` | `tags.${number}` | `security.${number}` | `security.${number}.${string}` | "externalDocs.description" | "externalDocs.url" | `requests.${number}` | `x-scalar-environments.${string}` | `children.${number}` | `securitySchemes.${number}` | `selectedSecuritySchemeUids.${number}` | `selectedSecuritySchemeUids.${number}.${number}` | "info.summary" | "info.description" | "info.title" | "info.version" | "info.termsOfService" | "info.contact" | "info.license" | "info.contact.name" | "info.contact.url" | "info.contact.email" | "info.license.name" | "info.license.url" | "info.license.identifier" | `components.${string}` | `webhooks.${string}` | `x-scalar-secrets.${string}`>(uid: string & import("zod").BRAND<"collection">, path: P, value: P extends "servers" | "tags" | "security" | "externalDocs" | "type" | "uid" | "requests" | "x-scalar-environments" | "children" | "openapi" | "x-scalar-icon" | "securitySchemes" | "selectedSecuritySchemeUids" | "watchMode" | "watchModeStatus" | "jsonSchemaDialect" | "info" | "components" | "webhooks" | "x-scalar-active-environment" | "x-scalar-secrets" | "selectedServerUid" | "documentUrl" | "integration" ? {
            type: "collection";
            uid: string & import("zod").BRAND<"collection">;
            children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
            openapi: string;
            security: Record<string, string[]>[];
            'x-scalar-icon': string;
            securitySchemes: string[];
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            servers: (string & import("zod").BRAND<"server">)[];
            requests: (string & import("zod").BRAND<"operation">)[];
            tags: (string & import("zod").BRAND<"tag">)[];
            watchMode: boolean;
            watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            jsonSchemaDialect?: string | undefined;
            info?: {
                title: string;
                version: string;
                description?: string | undefined;
                summary?: string | undefined;
                termsOfService?: string | undefined;
                contact?: {
                    name?: string | undefined;
                    url?: string | undefined;
                    email?: string | undefined;
                } | undefined;
                license?: {
                    name: string;
                    identifier?: string | undefined;
                    url?: string | undefined;
                } | undefined;
            } | undefined;
            components?: Record<string, unknown> | undefined;
            webhooks?: Record<string, unknown> | undefined;
            'x-scalar-active-environment'?: string | undefined;
            'x-scalar-environments'?: Record<string, {
                variables: Record<string, string | {
                    default: string;
                    description?: string | undefined;
                }>;
                description?: string | undefined;
                color?: string | undefined;
            }> | undefined;
            'x-scalar-secrets'?: Record<string, {
                example?: string | undefined;
                description?: string | undefined;
            }> | undefined;
            selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
            documentUrl?: string | undefined;
            integration?: string | null | undefined;
        }[P] : P extends `${infer K}.${infer R}` ? K extends "servers" | "tags" | "security" | "externalDocs" | "type" | "uid" | "requests" | "x-scalar-environments" | "children" | "openapi" | "x-scalar-icon" | "securitySchemes" | "selectedSecuritySchemeUids" | "watchMode" | "watchModeStatus" | "jsonSchemaDialect" | "info" | "components" | "webhooks" | "x-scalar-active-environment" | "x-scalar-secrets" | "selectedServerUid" | "documentUrl" | "integration" ? R extends import("@scalar/object-utils/nested").Path<{
            type: "collection";
            uid: string & import("zod").BRAND<"collection">;
            children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
            openapi: string;
            security: Record<string, string[]>[];
            'x-scalar-icon': string;
            securitySchemes: string[];
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            servers: (string & import("zod").BRAND<"server">)[];
            requests: (string & import("zod").BRAND<"operation">)[];
            tags: (string & import("zod").BRAND<"tag">)[];
            watchMode: boolean;
            watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            jsonSchemaDialect?: string | undefined;
            info?: {
                title: string;
                version: string;
                description?: string | undefined;
                summary?: string | undefined;
                termsOfService?: string | undefined;
                contact?: {
                    name?: string | undefined;
                    url?: string | undefined;
                    email?: string | undefined;
                } | undefined;
                license?: {
                    name: string;
                    identifier?: string | undefined;
                    url?: string | undefined;
                } | undefined;
            } | undefined;
            components?: Record<string, unknown> | undefined;
            webhooks?: Record<string, unknown> | undefined;
            'x-scalar-active-environment'?: string | undefined;
            'x-scalar-environments'?: Record<string, {
                variables: Record<string, string | {
                    default: string;
                    description?: string | undefined;
                }>;
                description?: string | undefined;
                color?: string | undefined;
            }> | undefined;
            'x-scalar-secrets'?: Record<string, {
                example?: string | undefined;
                description?: string | undefined;
            }> | undefined;
            selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
            documentUrl?: string | undefined;
            integration?: string | null | undefined;
        }[K]> ? import("@scalar/object-utils/nested").PathValue<{
            type: "collection";
            uid: string & import("zod").BRAND<"collection">;
            children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
            openapi: string;
            security: Record<string, string[]>[];
            'x-scalar-icon': string;
            securitySchemes: string[];
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            servers: (string & import("zod").BRAND<"server">)[];
            requests: (string & import("zod").BRAND<"operation">)[];
            tags: (string & import("zod").BRAND<"tag">)[];
            watchMode: boolean;
            watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            jsonSchemaDialect?: string | undefined;
            info?: {
                title: string;
                version: string;
                description?: string | undefined;
                summary?: string | undefined;
                termsOfService?: string | undefined;
                contact?: {
                    name?: string | undefined;
                    url?: string | undefined;
                    email?: string | undefined;
                } | undefined;
                license?: {
                    name: string;
                    identifier?: string | undefined;
                    url?: string | undefined;
                } | undefined;
            } | undefined;
            components?: Record<string, unknown> | undefined;
            webhooks?: Record<string, unknown> | undefined;
            'x-scalar-active-environment'?: string | undefined;
            'x-scalar-environments'?: Record<string, {
                variables: Record<string, string | {
                    default: string;
                    description?: string | undefined;
                }>;
                description?: string | undefined;
                color?: string | undefined;
            }> | undefined;
            'x-scalar-secrets'?: Record<string, {
                example?: string | undefined;
                description?: string | undefined;
            }> | undefined;
            selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
            documentUrl?: string | undefined;
            integration?: string | null | undefined;
        }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
        undo: (uid: string & import("zod").BRAND<"collection">) => void;
        redo: (uid: string & import("zod").BRAND<"collection">) => void;
        reset: () => void;
    };
};
/** Extended mutators and data for collections that required workspace access */
export declare function extendedCollectionDataFactory({ requests, requestMutators, requestExamples, requestExampleMutators, workspaces, workspaceMutators, collections, collectionMutators, tagMutators, serverMutators, }: StoreContext): {
    addCollection: (payload: CollectionPayload, workspaceUid: Workspace["uid"]) => {
        type: "collection";
        uid: string & import("zod").BRAND<"collection">;
        children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
        openapi: string;
        security: Record<string, string[]>[];
        'x-scalar-icon': string;
        securitySchemes: string[];
        selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
        servers: (string & import("zod").BRAND<"server">)[];
        requests: (string & import("zod").BRAND<"operation">)[];
        tags: (string & import("zod").BRAND<"tag">)[];
        watchMode: boolean;
        watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
        externalDocs?: {
            url: string;
            description?: string | undefined;
        } | undefined;
        jsonSchemaDialect?: string | undefined;
        info?: {
            title: string;
            version: string;
            description?: string | undefined;
            summary?: string | undefined;
            termsOfService?: string | undefined;
            contact?: {
                name?: string | undefined;
                url?: string | undefined;
                email?: string | undefined;
            } | undefined;
            license?: {
                name: string;
                identifier?: string | undefined;
                url?: string | undefined;
            } | undefined;
        } | undefined;
        components?: Record<string, unknown> | undefined;
        webhooks?: Record<string, unknown> | undefined;
        'x-scalar-active-environment'?: string | undefined;
        'x-scalar-environments'?: Record<string, {
            variables: Record<string, string | {
                default: string;
                description?: string | undefined;
            }>;
            description?: string | undefined;
            color?: string | undefined;
        }> | undefined;
        'x-scalar-secrets'?: Record<string, {
            example?: string | undefined;
            description?: string | undefined;
        }> | undefined;
        selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
        documentUrl?: string | undefined;
        integration?: string | null | undefined;
    };
    deleteCollection: (collection: Collection, workspace: Workspace) => void;
    addCollectionEnvironment: (environmentName: string, environment: XScalarEnvironment, collectionUid: Collection["uid"]) => void;
    removeCollectionEnvironment: (environmentName: string, collectionUid: Collection["uid"]) => void;
};
//# sourceMappingURL=collections.d.ts.map