import type { StoreContext } from '../store/store-context';
import { type Environment } from '@scalar/oas-utils/entities/environment';
/** Generate reactive environments for the workspace */
export declare function createStoreEnvironments(useLocalStorage: boolean): {
    environments: Record<string, {
        value: string;
        uid: string & import("zod").BRAND<"environment">;
        name: string;
        color: string;
        isDefault?: boolean | undefined;
    }>;
    environmentMutators: {
        add: (item: {
            value: string;
            uid: string & import("zod").BRAND<"environment">;
            name: string;
            color: string;
            isDefault?: boolean | undefined;
        }) => void;
        delete: (uid: (string & import("zod").BRAND<"environment">) | null | undefined) => void;
        set: (item: {
            value: string;
            uid: string & import("zod").BRAND<"environment">;
            name: string;
            color: string;
            isDefault?: boolean | undefined;
        }) => void;
        edit: <P extends "name" | "uid" | "color" | "value" | "isDefault">(uid: (string & import("zod").BRAND<"environment">) | null | undefined, path: P, value: P extends "name" | "uid" | "color" | "value" | "isDefault" ? {
            value: string;
            uid: string & import("zod").BRAND<"environment">;
            name: string;
            color: string;
            isDefault?: boolean | undefined;
        }[P] : P extends `${infer K}.${infer R}` ? K extends "name" | "uid" | "color" | "value" | "isDefault" ? R extends import("@scalar/object-utils/nested").Path<{
            value: string;
            uid: string & import("zod").BRAND<"environment">;
            name: string;
            color: string;
            isDefault?: boolean | undefined;
        }[K]> ? import("@scalar/object-utils/nested").PathValue<{
            value: string;
            uid: string & import("zod").BRAND<"environment">;
            name: string;
            color: string;
            isDefault?: boolean | undefined;
        }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
        untrackedEdit: <P extends "name" | "uid" | "color" | "value" | "isDefault">(uid: string & import("zod").BRAND<"environment">, path: P, value: P extends "name" | "uid" | "color" | "value" | "isDefault" ? {
            value: string;
            uid: string & import("zod").BRAND<"environment">;
            name: string;
            color: string;
            isDefault?: boolean | undefined;
        }[P] : P extends `${infer K}.${infer R}` ? K extends "name" | "uid" | "color" | "value" | "isDefault" ? R extends import("@scalar/object-utils/nested").Path<{
            value: string;
            uid: string & import("zod").BRAND<"environment">;
            name: string;
            color: string;
            isDefault?: boolean | undefined;
        }[K]> ? import("@scalar/object-utils/nested").PathValue<{
            value: string;
            uid: string & import("zod").BRAND<"environment">;
            name: string;
            color: string;
            isDefault?: boolean | undefined;
        }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
        undo: (uid: string & import("zod").BRAND<"environment">) => void;
        redo: (uid: string & import("zod").BRAND<"environment">) => void;
        reset: () => void;
    };
};
/** Extended environment data factory where workspace access is needed */
export declare function extendedEnvironmentDataFactory({ environmentMutators }: StoreContext): {
    deleteEnvironment: (uid: Environment["uid"]) => void;
};
//# sourceMappingURL=environment.d.ts.map