import { createEventBus as e } from "../libs/event-bus.js";
function r() {
  return {
    /**
     * Event bus to execute requests, usually triggered by the send button in the address bar
     * OR the keyboard shortcut
     */
    executeRequest: e(),
    /**
     * Event bus to cancel requests, usually triggered by response loading overlay
     */
    cancelRequest: e(),
    /**
     * Event bus to keep track of when a request is started, stopped, or aborted
     */
    requestStatus: e(),
    /**
     * Event bus for controlling the Command Palette
     *
     * @param commandName - the command name you wish to execute, leave empty for the full palette
     */
    commandPalette: e(),
    /**
     * Event bus for handling hot keys
     */
    hotKeys: e()
  };
}
export {
  r as createStoreEvents
};
