import type { StoreContext } from '../store/store-context';
import { type Request, type RequestExample } from '@scalar/oas-utils/entities/spec';
/** Create top level examples storage for the workspace */
export declare function createStoreRequestExamples(useLocalStorage: boolean): {
    requestExamples: Record<string, {
        type: "requestExample";
        uid: string & import("zod").BRAND<"example">;
        name: string;
        parameters: {
            path: {
                value: string;
                key: string;
                enabled: boolean;
                minimum?: number | undefined;
                type?: string | string[] | undefined;
                maximum?: number | undefined;
                default?: any;
                required?: boolean | undefined;
                description?: string | undefined;
                enum?: string[] | undefined;
                examples?: string[] | undefined;
                format?: string | undefined;
                file?: any;
                nullable?: boolean | undefined;
            }[];
            cookies: {
                value: string;
                key: string;
                enabled: boolean;
                minimum?: number | undefined;
                type?: string | string[] | undefined;
                maximum?: number | undefined;
                default?: any;
                required?: boolean | undefined;
                description?: string | undefined;
                enum?: string[] | undefined;
                examples?: string[] | undefined;
                format?: string | undefined;
                file?: any;
                nullable?: boolean | undefined;
            }[];
            query: {
                value: string;
                key: string;
                enabled: boolean;
                minimum?: number | undefined;
                type?: string | string[] | undefined;
                maximum?: number | undefined;
                default?: any;
                required?: boolean | undefined;
                description?: string | undefined;
                enum?: string[] | undefined;
                examples?: string[] | undefined;
                format?: string | undefined;
                file?: any;
                nullable?: boolean | undefined;
            }[];
            headers: {
                value: string;
                key: string;
                enabled: boolean;
                minimum?: number | undefined;
                type?: string | string[] | undefined;
                maximum?: number | undefined;
                default?: any;
                required?: boolean | undefined;
                description?: string | undefined;
                enum?: string[] | undefined;
                examples?: string[] | undefined;
                format?: string | undefined;
                file?: any;
                nullable?: boolean | undefined;
            }[];
        };
        body: {
            activeBody: "binary" | "formData" | "raw";
            binary?: Blob | undefined;
            formData?: {
                value: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                encoding: "form-data" | "urlencoded";
            } | undefined;
            raw?: {
                value: string;
                encoding: "xml" | "text" | "json" | "html" | "javascript" | "yaml" | "edn";
            } | undefined;
        };
        requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
        serverVariables?: Record<string, string[]> | undefined;
    }>;
    requestExampleMutators: {
        add: (item: {
            type: "requestExample";
            uid: string & import("zod").BRAND<"example">;
            name: string;
            parameters: {
                path: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                cookies: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                query: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                headers: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
            };
            body: {
                activeBody: "binary" | "formData" | "raw";
                binary?: Blob | undefined;
                formData?: {
                    value: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        description?: string | undefined;
                        enum?: string[] | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    encoding: "form-data" | "urlencoded";
                } | undefined;
                raw?: {
                    value: string;
                    encoding: "xml" | "text" | "json" | "html" | "javascript" | "yaml" | "edn";
                } | undefined;
            };
            requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
            serverVariables?: Record<string, string[]> | undefined;
        }) => void;
        delete: (uid: (string & import("zod").BRAND<"example">) | null | undefined) => void;
        set: (item: {
            type: "requestExample";
            uid: string & import("zod").BRAND<"example">;
            name: string;
            parameters: {
                path: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                cookies: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                query: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                headers: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
            };
            body: {
                activeBody: "binary" | "formData" | "raw";
                binary?: Blob | undefined;
                formData?: {
                    value: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        description?: string | undefined;
                        enum?: string[] | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    encoding: "form-data" | "urlencoded";
                } | undefined;
                raw?: {
                    value: string;
                    encoding: "xml" | "text" | "json" | "html" | "javascript" | "yaml" | "edn";
                } | undefined;
            };
            requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
            serverVariables?: Record<string, string[]> | undefined;
        }) => void;
        edit: <P extends "parameters" | "type" | "name" | "uid" | "body" | "requestUid" | "serverVariables" | "body.formData.value" | "parameters.cookies" | `parameters.cookies.${number}` | "parameters.path" | "parameters.headers" | "parameters.query" | `parameters.cookies.${number}.description` | `parameters.cookies.${number}.required` | `parameters.cookies.${number}.examples` | `parameters.cookies.${number}.type` | `parameters.cookies.${number}.default` | `parameters.cookies.${number}.key` | `parameters.cookies.${number}.file` | `parameters.cookies.${number}.value` | `parameters.cookies.${number}.enum` | `parameters.cookies.${number}.nullable` | `parameters.cookies.${number}.format` | `parameters.cookies.${number}.maximum` | `parameters.cookies.${number}.minimum` | `parameters.cookies.${number}.examples.${number}` | `parameters.cookies.${number}.enum.${number}` | `parameters.cookies.${number}.enabled` | `parameters.cookies.${number}.type.${number}` | `parameters.cookies.${number}.default.${string}` | `parameters.cookies.${number}.file.${string}` | `parameters.path.${number}` | `parameters.path.${number}.description` | `parameters.path.${number}.required` | `parameters.path.${number}.examples` | `parameters.path.${number}.type` | `parameters.path.${number}.default` | `parameters.path.${number}.key` | `parameters.path.${number}.file` | `parameters.path.${number}.value` | `parameters.path.${number}.enum` | `parameters.path.${number}.nullable` | `parameters.path.${number}.format` | `parameters.path.${number}.maximum` | `parameters.path.${number}.minimum` | `parameters.path.${number}.examples.${number}` | `parameters.path.${number}.enum.${number}` | `parameters.path.${number}.enabled` | `parameters.path.${number}.type.${number}` | `parameters.path.${number}.default.${string}` | `parameters.path.${number}.file.${string}` | `parameters.headers.${number}` | `parameters.headers.${number}.description` | `parameters.headers.${number}.required` | `parameters.headers.${number}.examples` | `parameters.headers.${number}.type` | `parameters.headers.${number}.default` | `parameters.headers.${number}.key` | `parameters.headers.${number}.file` | `parameters.headers.${number}.value` | `parameters.headers.${number}.enum` | `parameters.headers.${number}.nullable` | `parameters.headers.${number}.format` | `parameters.headers.${number}.maximum` | `parameters.headers.${number}.minimum` | `parameters.headers.${number}.examples.${number}` | `parameters.headers.${number}.enum.${number}` | `parameters.headers.${number}.enabled` | `parameters.headers.${number}.type.${number}` | `parameters.headers.${number}.default.${string}` | `parameters.headers.${number}.file.${string}` | `parameters.query.${number}` | `parameters.query.${number}.description` | `parameters.query.${number}.required` | `parameters.query.${number}.examples` | `parameters.query.${number}.type` | `parameters.query.${number}.default` | `parameters.query.${number}.key` | `parameters.query.${number}.file` | `parameters.query.${number}.value` | `parameters.query.${number}.enum` | `parameters.query.${number}.nullable` | `parameters.query.${number}.format` | `parameters.query.${number}.maximum` | `parameters.query.${number}.minimum` | `parameters.query.${number}.examples.${number}` | `parameters.query.${number}.enum.${number}` | `parameters.query.${number}.enabled` | `parameters.query.${number}.type.${number}` | `parameters.query.${number}.default.${string}` | `parameters.query.${number}.file.${string}` | "body.binary" | "body.formData" | "body.raw" | "body.activeBody" | "body.binary.type" | "body.binary.size" | "body.binary.slice" | "body.binary.text" | "body.binary.arrayBuffer" | "body.binary.stream" | "body.formData.encoding" | `body.formData.value.${number}` | `body.formData.value.${number}.description` | `body.formData.value.${number}.required` | `body.formData.value.${number}.examples` | `body.formData.value.${number}.type` | `body.formData.value.${number}.default` | `body.formData.value.${number}.key` | `body.formData.value.${number}.file` | `body.formData.value.${number}.value` | `body.formData.value.${number}.enum` | `body.formData.value.${number}.nullable` | `body.formData.value.${number}.format` | `body.formData.value.${number}.maximum` | `body.formData.value.${number}.minimum` | `body.formData.value.${number}.examples.${number}` | `body.formData.value.${number}.enum.${number}` | `body.formData.value.${number}.enabled` | `body.formData.value.${number}.type.${number}` | `body.formData.value.${number}.default.${string}` | `body.formData.value.${number}.file.${string}` | "body.raw.value" | "body.raw.encoding" | `serverVariables.${string}`>(uid: (string & import("zod").BRAND<"example">) | null | undefined, path: P, value: P extends "parameters" | "type" | "name" | "uid" | "body" | "requestUid" | "serverVariables" ? {
            type: "requestExample";
            uid: string & import("zod").BRAND<"example">;
            name: string;
            parameters: {
                path: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                cookies: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                query: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                headers: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
            };
            body: {
                activeBody: "binary" | "formData" | "raw";
                binary?: Blob | undefined;
                formData?: {
                    value: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        description?: string | undefined;
                        enum?: string[] | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    encoding: "form-data" | "urlencoded";
                } | undefined;
                raw?: {
                    value: string;
                    encoding: "xml" | "text" | "json" | "html" | "javascript" | "yaml" | "edn";
                } | undefined;
            };
            requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
            serverVariables?: Record<string, string[]> | undefined;
        }[P] : P extends `${infer K}.${infer R}` ? K extends "parameters" | "type" | "name" | "uid" | "body" | "requestUid" | "serverVariables" ? R extends import("@scalar/object-utils/nested").Path<{
            type: "requestExample";
            uid: string & import("zod").BRAND<"example">;
            name: string;
            parameters: {
                path: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                cookies: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                query: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                headers: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
            };
            body: {
                activeBody: "binary" | "formData" | "raw";
                binary?: Blob | undefined;
                formData?: {
                    value: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        description?: string | undefined;
                        enum?: string[] | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    encoding: "form-data" | "urlencoded";
                } | undefined;
                raw?: {
                    value: string;
                    encoding: "xml" | "text" | "json" | "html" | "javascript" | "yaml" | "edn";
                } | undefined;
            };
            requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
            serverVariables?: Record<string, string[]> | undefined;
        }[K]> ? import("@scalar/object-utils/nested").PathValue<{
            type: "requestExample";
            uid: string & import("zod").BRAND<"example">;
            name: string;
            parameters: {
                path: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                cookies: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                query: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                headers: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
            };
            body: {
                activeBody: "binary" | "formData" | "raw";
                binary?: Blob | undefined;
                formData?: {
                    value: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        description?: string | undefined;
                        enum?: string[] | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    encoding: "form-data" | "urlencoded";
                } | undefined;
                raw?: {
                    value: string;
                    encoding: "xml" | "text" | "json" | "html" | "javascript" | "yaml" | "edn";
                } | undefined;
            };
            requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
            serverVariables?: Record<string, string[]> | undefined;
        }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
        untrackedEdit: <P extends "parameters" | "type" | "name" | "uid" | "body" | "requestUid" | "serverVariables" | "body.formData.value" | "parameters.cookies" | `parameters.cookies.${number}` | "parameters.path" | "parameters.headers" | "parameters.query" | `parameters.cookies.${number}.description` | `parameters.cookies.${number}.required` | `parameters.cookies.${number}.examples` | `parameters.cookies.${number}.type` | `parameters.cookies.${number}.default` | `parameters.cookies.${number}.key` | `parameters.cookies.${number}.file` | `parameters.cookies.${number}.value` | `parameters.cookies.${number}.enum` | `parameters.cookies.${number}.nullable` | `parameters.cookies.${number}.format` | `parameters.cookies.${number}.maximum` | `parameters.cookies.${number}.minimum` | `parameters.cookies.${number}.examples.${number}` | `parameters.cookies.${number}.enum.${number}` | `parameters.cookies.${number}.enabled` | `parameters.cookies.${number}.type.${number}` | `parameters.cookies.${number}.default.${string}` | `parameters.cookies.${number}.file.${string}` | `parameters.path.${number}` | `parameters.path.${number}.description` | `parameters.path.${number}.required` | `parameters.path.${number}.examples` | `parameters.path.${number}.type` | `parameters.path.${number}.default` | `parameters.path.${number}.key` | `parameters.path.${number}.file` | `parameters.path.${number}.value` | `parameters.path.${number}.enum` | `parameters.path.${number}.nullable` | `parameters.path.${number}.format` | `parameters.path.${number}.maximum` | `parameters.path.${number}.minimum` | `parameters.path.${number}.examples.${number}` | `parameters.path.${number}.enum.${number}` | `parameters.path.${number}.enabled` | `parameters.path.${number}.type.${number}` | `parameters.path.${number}.default.${string}` | `parameters.path.${number}.file.${string}` | `parameters.headers.${number}` | `parameters.headers.${number}.description` | `parameters.headers.${number}.required` | `parameters.headers.${number}.examples` | `parameters.headers.${number}.type` | `parameters.headers.${number}.default` | `parameters.headers.${number}.key` | `parameters.headers.${number}.file` | `parameters.headers.${number}.value` | `parameters.headers.${number}.enum` | `parameters.headers.${number}.nullable` | `parameters.headers.${number}.format` | `parameters.headers.${number}.maximum` | `parameters.headers.${number}.minimum` | `parameters.headers.${number}.examples.${number}` | `parameters.headers.${number}.enum.${number}` | `parameters.headers.${number}.enabled` | `parameters.headers.${number}.type.${number}` | `parameters.headers.${number}.default.${string}` | `parameters.headers.${number}.file.${string}` | `parameters.query.${number}` | `parameters.query.${number}.description` | `parameters.query.${number}.required` | `parameters.query.${number}.examples` | `parameters.query.${number}.type` | `parameters.query.${number}.default` | `parameters.query.${number}.key` | `parameters.query.${number}.file` | `parameters.query.${number}.value` | `parameters.query.${number}.enum` | `parameters.query.${number}.nullable` | `parameters.query.${number}.format` | `parameters.query.${number}.maximum` | `parameters.query.${number}.minimum` | `parameters.query.${number}.examples.${number}` | `parameters.query.${number}.enum.${number}` | `parameters.query.${number}.enabled` | `parameters.query.${number}.type.${number}` | `parameters.query.${number}.default.${string}` | `parameters.query.${number}.file.${string}` | "body.binary" | "body.formData" | "body.raw" | "body.activeBody" | "body.binary.type" | "body.binary.size" | "body.binary.slice" | "body.binary.text" | "body.binary.arrayBuffer" | "body.binary.stream" | "body.formData.encoding" | `body.formData.value.${number}` | `body.formData.value.${number}.description` | `body.formData.value.${number}.required` | `body.formData.value.${number}.examples` | `body.formData.value.${number}.type` | `body.formData.value.${number}.default` | `body.formData.value.${number}.key` | `body.formData.value.${number}.file` | `body.formData.value.${number}.value` | `body.formData.value.${number}.enum` | `body.formData.value.${number}.nullable` | `body.formData.value.${number}.format` | `body.formData.value.${number}.maximum` | `body.formData.value.${number}.minimum` | `body.formData.value.${number}.examples.${number}` | `body.formData.value.${number}.enum.${number}` | `body.formData.value.${number}.enabled` | `body.formData.value.${number}.type.${number}` | `body.formData.value.${number}.default.${string}` | `body.formData.value.${number}.file.${string}` | "body.raw.value" | "body.raw.encoding" | `serverVariables.${string}`>(uid: string & import("zod").BRAND<"example">, path: P, value: P extends "parameters" | "type" | "name" | "uid" | "body" | "requestUid" | "serverVariables" ? {
            type: "requestExample";
            uid: string & import("zod").BRAND<"example">;
            name: string;
            parameters: {
                path: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                cookies: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                query: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                headers: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
            };
            body: {
                activeBody: "binary" | "formData" | "raw";
                binary?: Blob | undefined;
                formData?: {
                    value: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        description?: string | undefined;
                        enum?: string[] | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    encoding: "form-data" | "urlencoded";
                } | undefined;
                raw?: {
                    value: string;
                    encoding: "xml" | "text" | "json" | "html" | "javascript" | "yaml" | "edn";
                } | undefined;
            };
            requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
            serverVariables?: Record<string, string[]> | undefined;
        }[P] : P extends `${infer K}.${infer R}` ? K extends "parameters" | "type" | "name" | "uid" | "body" | "requestUid" | "serverVariables" ? R extends import("@scalar/object-utils/nested").Path<{
            type: "requestExample";
            uid: string & import("zod").BRAND<"example">;
            name: string;
            parameters: {
                path: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                cookies: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                query: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                headers: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
            };
            body: {
                activeBody: "binary" | "formData" | "raw";
                binary?: Blob | undefined;
                formData?: {
                    value: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        description?: string | undefined;
                        enum?: string[] | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    encoding: "form-data" | "urlencoded";
                } | undefined;
                raw?: {
                    value: string;
                    encoding: "xml" | "text" | "json" | "html" | "javascript" | "yaml" | "edn";
                } | undefined;
            };
            requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
            serverVariables?: Record<string, string[]> | undefined;
        }[K]> ? import("@scalar/object-utils/nested").PathValue<{
            type: "requestExample";
            uid: string & import("zod").BRAND<"example">;
            name: string;
            parameters: {
                path: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                cookies: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                query: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                headers: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
            };
            body: {
                activeBody: "binary" | "formData" | "raw";
                binary?: Blob | undefined;
                formData?: {
                    value: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        description?: string | undefined;
                        enum?: string[] | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    encoding: "form-data" | "urlencoded";
                } | undefined;
                raw?: {
                    value: string;
                    encoding: "xml" | "text" | "json" | "html" | "javascript" | "yaml" | "edn";
                } | undefined;
            };
            requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
            serverVariables?: Record<string, string[]> | undefined;
        }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
        undo: (uid: string & import("zod").BRAND<"example">) => void;
        redo: (uid: string & import("zod").BRAND<"example">) => void;
        reset: () => void;
    };
};
/** Extended example data that needs store context */
export declare function extendedExampleDataFactory({ requestExamples, requestExampleMutators, requestMutators, requests, }: StoreContext): {
    addRequestExample: (request: Request, _name?: string) => {
        type: "requestExample";
        uid: string & import("zod").BRAND<"example">;
        name: string;
        parameters: {
            path: {
                value: string;
                key: string;
                enabled: boolean;
                minimum?: number | undefined;
                type?: string | string[] | undefined;
                maximum?: number | undefined;
                default?: any;
                required?: boolean | undefined;
                description?: string | undefined;
                enum?: string[] | undefined;
                examples?: string[] | undefined;
                format?: string | undefined;
                file?: any;
                nullable?: boolean | undefined;
            }[];
            cookies: {
                value: string;
                key: string;
                enabled: boolean;
                minimum?: number | undefined;
                type?: string | string[] | undefined;
                maximum?: number | undefined;
                default?: any;
                required?: boolean | undefined;
                description?: string | undefined;
                enum?: string[] | undefined;
                examples?: string[] | undefined;
                format?: string | undefined;
                file?: any;
                nullable?: boolean | undefined;
            }[];
            query: {
                value: string;
                key: string;
                enabled: boolean;
                minimum?: number | undefined;
                type?: string | string[] | undefined;
                maximum?: number | undefined;
                default?: any;
                required?: boolean | undefined;
                description?: string | undefined;
                enum?: string[] | undefined;
                examples?: string[] | undefined;
                format?: string | undefined;
                file?: any;
                nullable?: boolean | undefined;
            }[];
            headers: {
                value: string;
                key: string;
                enabled: boolean;
                minimum?: number | undefined;
                type?: string | string[] | undefined;
                maximum?: number | undefined;
                default?: any;
                required?: boolean | undefined;
                description?: string | undefined;
                enum?: string[] | undefined;
                examples?: string[] | undefined;
                format?: string | undefined;
                file?: any;
                nullable?: boolean | undefined;
            }[];
        };
        body: {
            activeBody: "binary" | "formData" | "raw";
            binary?: Blob | undefined;
            formData?: {
                value: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    description?: string | undefined;
                    enum?: string[] | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                encoding: "form-data" | "urlencoded";
            } | undefined;
            raw?: {
                value: string;
                encoding: "xml" | "text" | "json" | "html" | "javascript" | "yaml" | "edn";
            } | undefined;
        };
        requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
        serverVariables?: Record<string, string[]> | undefined;
    };
    deleteRequestExample: (requestExample: RequestExample) => void;
};
//# sourceMappingURL=request-example.d.ts.map