import type { extendedTagDataFactory } from '../store/tags';
import { type Collection, type Request, type RequestPayload, type Tag } from '@scalar/oas-utils/entities/spec';
import type { StoreContext } from './store-context';
/** Create top level request handlers for a workspace */
export declare function createStoreRequests(useLocalStorage: boolean): {
    requests: Record<string, {
        path: string;
        type: "request";
        uid: string & import("zod").BRAND<"operation">;
        selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
        selectedServerUid: (string & import("zod").BRAND<"server">) | null;
        servers: (string & import("zod").BRAND<"server">)[];
        examples: (string & import("zod").BRAND<"example">)[];
        method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
        description?: string | undefined;
        summary?: string | undefined;
        externalDocs?: {
            url: string;
            description?: string | undefined;
        } | undefined;
        'x-internal'?: boolean | undefined;
        'x-scalar-ignore'?: boolean | undefined;
        security?: Record<string, string[]>[] | undefined;
        tags?: string[] | undefined;
        deprecated?: boolean | undefined;
        operationId?: string | undefined;
        parameters?: {
            required: boolean;
            name: string;
            in: "path" | "cookie" | "query" | "header";
            deprecated: boolean;
            example?: unknown;
            description?: string | undefined;
            schema?: unknown;
            content?: unknown;
            style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
            examples?: Record<string, {
                value?: unknown;
                summary?: string | undefined;
            }> | undefined;
        }[] | undefined;
        requestBody?: any;
        responses?: Record<string, any> | undefined;
    }>;
    requestMutators: {
        add: (item: {
            path: string;
            type: "request";
            uid: string & import("zod").BRAND<"operation">;
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            selectedServerUid: (string & import("zod").BRAND<"server">) | null;
            servers: (string & import("zod").BRAND<"server">)[];
            examples: (string & import("zod").BRAND<"example">)[];
            method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
            description?: string | undefined;
            summary?: string | undefined;
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            'x-internal'?: boolean | undefined;
            'x-scalar-ignore'?: boolean | undefined;
            security?: Record<string, string[]>[] | undefined;
            tags?: string[] | undefined;
            deprecated?: boolean | undefined;
            operationId?: string | undefined;
            parameters?: {
                required: boolean;
                name: string;
                in: "path" | "cookie" | "query" | "header";
                deprecated: boolean;
                example?: unknown;
                description?: string | undefined;
                schema?: unknown;
                content?: unknown;
                style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                examples?: Record<string, {
                    value?: unknown;
                    summary?: string | undefined;
                }> | undefined;
            }[] | undefined;
            requestBody?: any;
            responses?: Record<string, any> | undefined;
        }) => void;
        delete: (uid: (string & import("zod").BRAND<"operation">) | null | undefined) => void;
        set: (item: {
            path: string;
            type: "request";
            uid: string & import("zod").BRAND<"operation">;
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            selectedServerUid: (string & import("zod").BRAND<"server">) | null;
            servers: (string & import("zod").BRAND<"server">)[];
            examples: (string & import("zod").BRAND<"example">)[];
            method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
            description?: string | undefined;
            summary?: string | undefined;
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            'x-internal'?: boolean | undefined;
            'x-scalar-ignore'?: boolean | undefined;
            security?: Record<string, string[]>[] | undefined;
            tags?: string[] | undefined;
            deprecated?: boolean | undefined;
            operationId?: string | undefined;
            parameters?: {
                required: boolean;
                name: string;
                in: "path" | "cookie" | "query" | "header";
                deprecated: boolean;
                example?: unknown;
                description?: string | undefined;
                schema?: unknown;
                content?: unknown;
                style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                examples?: Record<string, {
                    value?: unknown;
                    summary?: string | undefined;
                }> | undefined;
            }[] | undefined;
            requestBody?: any;
            responses?: Record<string, any> | undefined;
        }) => void;
        edit: <P extends "servers" | "tags" | "summary" | "description" | "operationId" | "security" | "requestBody" | "parameters" | "externalDocs" | "deprecated" | "responses" | "x-internal" | "x-scalar-ignore" | "type" | "uid" | "selectedSecuritySchemeUids" | "selectedServerUid" | `servers.${number}` | `tags.${number}` | `security.${number}` | `security.${number}.${string}` | "externalDocs.description" | "externalDocs.url" | `selectedSecuritySchemeUids.${number}` | `selectedSecuritySchemeUids.${number}.${number}` | "path" | "method" | "examples" | `requestBody.${string}` | `parameters.${number}` | `parameters.${number}.description` | `parameters.${number}.deprecated` | `parameters.${number}.name` | `parameters.${number}.in` | `parameters.${number}.example` | `parameters.${number}.style` | `parameters.${number}.required` | `parameters.${number}.examples` | `parameters.${number}.content` | `parameters.${number}.schema` | `parameters.${number}.examples.${string}` | `responses.${string}` | `examples.${number}`>(uid: (string & import("zod").BRAND<"operation">) | null | undefined, path: P, value: P extends "servers" | "tags" | "summary" | "description" | "operationId" | "security" | "requestBody" | "parameters" | "externalDocs" | "deprecated" | "responses" | "x-internal" | "x-scalar-ignore" | "type" | "uid" | "selectedSecuritySchemeUids" | "selectedServerUid" | "path" | "method" | "examples" ? {
            path: string;
            type: "request";
            uid: string & import("zod").BRAND<"operation">;
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            selectedServerUid: (string & import("zod").BRAND<"server">) | null;
            servers: (string & import("zod").BRAND<"server">)[];
            examples: (string & import("zod").BRAND<"example">)[];
            method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
            description?: string | undefined;
            summary?: string | undefined;
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            'x-internal'?: boolean | undefined;
            'x-scalar-ignore'?: boolean | undefined;
            security?: Record<string, string[]>[] | undefined;
            tags?: string[] | undefined;
            deprecated?: boolean | undefined;
            operationId?: string | undefined;
            parameters?: {
                required: boolean;
                name: string;
                in: "path" | "cookie" | "query" | "header";
                deprecated: boolean;
                example?: unknown;
                description?: string | undefined;
                schema?: unknown;
                content?: unknown;
                style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                examples?: Record<string, {
                    value?: unknown;
                    summary?: string | undefined;
                }> | undefined;
            }[] | undefined;
            requestBody?: any;
            responses?: Record<string, any> | undefined;
        }[P] : P extends `${infer K}.${infer R}` ? K extends "servers" | "tags" | "summary" | "description" | "operationId" | "security" | "requestBody" | "parameters" | "externalDocs" | "deprecated" | "responses" | "x-internal" | "x-scalar-ignore" | "type" | "uid" | "selectedSecuritySchemeUids" | "selectedServerUid" | "path" | "method" | "examples" ? R extends import("@scalar/object-utils/nested").Path<{
            path: string;
            type: "request";
            uid: string & import("zod").BRAND<"operation">;
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            selectedServerUid: (string & import("zod").BRAND<"server">) | null;
            servers: (string & import("zod").BRAND<"server">)[];
            examples: (string & import("zod").BRAND<"example">)[];
            method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
            description?: string | undefined;
            summary?: string | undefined;
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            'x-internal'?: boolean | undefined;
            'x-scalar-ignore'?: boolean | undefined;
            security?: Record<string, string[]>[] | undefined;
            tags?: string[] | undefined;
            deprecated?: boolean | undefined;
            operationId?: string | undefined;
            parameters?: {
                required: boolean;
                name: string;
                in: "path" | "cookie" | "query" | "header";
                deprecated: boolean;
                example?: unknown;
                description?: string | undefined;
                schema?: unknown;
                content?: unknown;
                style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                examples?: Record<string, {
                    value?: unknown;
                    summary?: string | undefined;
                }> | undefined;
            }[] | undefined;
            requestBody?: any;
            responses?: Record<string, any> | undefined;
        }[K]> ? import("@scalar/object-utils/nested").PathValue<{
            path: string;
            type: "request";
            uid: string & import("zod").BRAND<"operation">;
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            selectedServerUid: (string & import("zod").BRAND<"server">) | null;
            servers: (string & import("zod").BRAND<"server">)[];
            examples: (string & import("zod").BRAND<"example">)[];
            method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
            description?: string | undefined;
            summary?: string | undefined;
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            'x-internal'?: boolean | undefined;
            'x-scalar-ignore'?: boolean | undefined;
            security?: Record<string, string[]>[] | undefined;
            tags?: string[] | undefined;
            deprecated?: boolean | undefined;
            operationId?: string | undefined;
            parameters?: {
                required: boolean;
                name: string;
                in: "path" | "cookie" | "query" | "header";
                deprecated: boolean;
                example?: unknown;
                description?: string | undefined;
                schema?: unknown;
                content?: unknown;
                style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                examples?: Record<string, {
                    value?: unknown;
                    summary?: string | undefined;
                }> | undefined;
            }[] | undefined;
            requestBody?: any;
            responses?: Record<string, any> | undefined;
        }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
        untrackedEdit: <P extends "servers" | "tags" | "summary" | "description" | "operationId" | "security" | "requestBody" | "parameters" | "externalDocs" | "deprecated" | "responses" | "x-internal" | "x-scalar-ignore" | "type" | "uid" | "selectedSecuritySchemeUids" | "selectedServerUid" | `servers.${number}` | `tags.${number}` | `security.${number}` | `security.${number}.${string}` | "externalDocs.description" | "externalDocs.url" | `selectedSecuritySchemeUids.${number}` | `selectedSecuritySchemeUids.${number}.${number}` | "path" | "method" | "examples" | `requestBody.${string}` | `parameters.${number}` | `parameters.${number}.description` | `parameters.${number}.deprecated` | `parameters.${number}.name` | `parameters.${number}.in` | `parameters.${number}.example` | `parameters.${number}.style` | `parameters.${number}.required` | `parameters.${number}.examples` | `parameters.${number}.content` | `parameters.${number}.schema` | `parameters.${number}.examples.${string}` | `responses.${string}` | `examples.${number}`>(uid: string & import("zod").BRAND<"operation">, path: P, value: P extends "servers" | "tags" | "summary" | "description" | "operationId" | "security" | "requestBody" | "parameters" | "externalDocs" | "deprecated" | "responses" | "x-internal" | "x-scalar-ignore" | "type" | "uid" | "selectedSecuritySchemeUids" | "selectedServerUid" | "path" | "method" | "examples" ? {
            path: string;
            type: "request";
            uid: string & import("zod").BRAND<"operation">;
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            selectedServerUid: (string & import("zod").BRAND<"server">) | null;
            servers: (string & import("zod").BRAND<"server">)[];
            examples: (string & import("zod").BRAND<"example">)[];
            method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
            description?: string | undefined;
            summary?: string | undefined;
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            'x-internal'?: boolean | undefined;
            'x-scalar-ignore'?: boolean | undefined;
            security?: Record<string, string[]>[] | undefined;
            tags?: string[] | undefined;
            deprecated?: boolean | undefined;
            operationId?: string | undefined;
            parameters?: {
                required: boolean;
                name: string;
                in: "path" | "cookie" | "query" | "header";
                deprecated: boolean;
                example?: unknown;
                description?: string | undefined;
                schema?: unknown;
                content?: unknown;
                style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                examples?: Record<string, {
                    value?: unknown;
                    summary?: string | undefined;
                }> | undefined;
            }[] | undefined;
            requestBody?: any;
            responses?: Record<string, any> | undefined;
        }[P] : P extends `${infer K}.${infer R}` ? K extends "servers" | "tags" | "summary" | "description" | "operationId" | "security" | "requestBody" | "parameters" | "externalDocs" | "deprecated" | "responses" | "x-internal" | "x-scalar-ignore" | "type" | "uid" | "selectedSecuritySchemeUids" | "selectedServerUid" | "path" | "method" | "examples" ? R extends import("@scalar/object-utils/nested").Path<{
            path: string;
            type: "request";
            uid: string & import("zod").BRAND<"operation">;
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            selectedServerUid: (string & import("zod").BRAND<"server">) | null;
            servers: (string & import("zod").BRAND<"server">)[];
            examples: (string & import("zod").BRAND<"example">)[];
            method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
            description?: string | undefined;
            summary?: string | undefined;
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            'x-internal'?: boolean | undefined;
            'x-scalar-ignore'?: boolean | undefined;
            security?: Record<string, string[]>[] | undefined;
            tags?: string[] | undefined;
            deprecated?: boolean | undefined;
            operationId?: string | undefined;
            parameters?: {
                required: boolean;
                name: string;
                in: "path" | "cookie" | "query" | "header";
                deprecated: boolean;
                example?: unknown;
                description?: string | undefined;
                schema?: unknown;
                content?: unknown;
                style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                examples?: Record<string, {
                    value?: unknown;
                    summary?: string | undefined;
                }> | undefined;
            }[] | undefined;
            requestBody?: any;
            responses?: Record<string, any> | undefined;
        }[K]> ? import("@scalar/object-utils/nested").PathValue<{
            path: string;
            type: "request";
            uid: string & import("zod").BRAND<"operation">;
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            selectedServerUid: (string & import("zod").BRAND<"server">) | null;
            servers: (string & import("zod").BRAND<"server">)[];
            examples: (string & import("zod").BRAND<"example">)[];
            method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
            description?: string | undefined;
            summary?: string | undefined;
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            'x-internal'?: boolean | undefined;
            'x-scalar-ignore'?: boolean | undefined;
            security?: Record<string, string[]>[] | undefined;
            tags?: string[] | undefined;
            deprecated?: boolean | undefined;
            operationId?: string | undefined;
            parameters?: {
                required: boolean;
                name: string;
                in: "path" | "cookie" | "query" | "header";
                deprecated: boolean;
                example?: unknown;
                description?: string | undefined;
                schema?: unknown;
                content?: unknown;
                style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                examples?: Record<string, {
                    value?: unknown;
                    summary?: string | undefined;
                }> | undefined;
            }[] | undefined;
            requestBody?: any;
            responses?: Record<string, any> | undefined;
        }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
        undo: (uid: string & import("zod").BRAND<"operation">) => void;
        redo: (uid: string & import("zod").BRAND<"operation">) => void;
        reset: () => void;
    };
};
type AddTag = ReturnType<typeof extendedTagDataFactory>['addTag'];
/**
 * Create the extended mutators for request where access to the workspace is required
 */
export declare function extendedRequestDataFactory({ requestExamples, requestExampleMutators, requestMutators, collectionMutators, collections, tags, tagMutators, }: StoreContext, addTag: AddTag): {
    addRequest: (payload: RequestPayload, collectionUid: Collection["uid"]) => void | {
        path: string;
        type: "request";
        uid: string & import("zod").BRAND<"operation">;
        selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
        selectedServerUid: (string & import("zod").BRAND<"server">) | null;
        servers: (string & import("zod").BRAND<"server">)[];
        examples: (string & import("zod").BRAND<"example">)[];
        method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
        description?: string | undefined;
        summary?: string | undefined;
        externalDocs?: {
            url: string;
            description?: string | undefined;
        } | undefined;
        'x-internal'?: boolean | undefined;
        'x-scalar-ignore'?: boolean | undefined;
        security?: Record<string, string[]>[] | undefined;
        tags?: string[] | undefined;
        deprecated?: boolean | undefined;
        operationId?: string | undefined;
        parameters?: {
            required: boolean;
            name: string;
            in: "path" | "cookie" | "query" | "header";
            deprecated: boolean;
            example?: unknown;
            description?: string | undefined;
            schema?: unknown;
            content?: unknown;
            style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
            examples?: Record<string, {
                value?: unknown;
                summary?: string | undefined;
            }> | undefined;
        }[] | undefined;
        requestBody?: any;
        responses?: Record<string, any> | undefined;
    };
    deleteRequest: (request: Request, collectionUid: Collection["uid"]) => void;
    findRequestParents: (r: Request) => string[];
};
/** Factory function to allow testing of the function */
export declare function findRequestParentsFactory({ collections, tags, }: {
    collections: Record<string, Collection>;
    tags: Record<string, Tag>;
}): (r: Request) => string[];
/** First draft request" */
export declare function createInitialRequest(): {
    request: {
        path: string;
        type: "request";
        uid: string & import("zod").BRAND<"operation">;
        selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
        selectedServerUid: (string & import("zod").BRAND<"server">) | null;
        servers: (string & import("zod").BRAND<"server">)[];
        examples: (string & import("zod").BRAND<"example">)[];
        method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
        description?: string | undefined;
        summary?: string | undefined;
        externalDocs?: {
            url: string;
            description?: string | undefined;
        } | undefined;
        'x-internal'?: boolean | undefined;
        'x-scalar-ignore'?: boolean | undefined;
        security?: Record<string, string[]>[] | undefined;
        tags?: string[] | undefined;
        deprecated?: boolean | undefined;
        operationId?: string | undefined;
        parameters?: {
            required: boolean;
            name: string;
            in: "path" | "cookie" | "query" | "header";
            deprecated: boolean;
            example?: unknown;
            description?: string | undefined;
            schema?: unknown;
            content?: unknown;
            style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
            examples?: Record<string, {
                value?: unknown;
                summary?: string | undefined;
            }> | undefined;
        }[] | undefined;
        requestBody?: any;
        responses?: Record<string, any> | undefined;
    };
};
export {};
//# sourceMappingURL=requests.d.ts.map