import type { StoreContext } from '../store/store-context';
import { type Collection, type SecurityScheme, type SecuritySchemePayload } from '@scalar/oas-utils/entities/spec';
/** Create storage entities for security schemes */
export declare function createStoreSecuritySchemes(useLocalStorage: boolean): {
    securitySchemes: Record<string, {
        type: "apiKey";
        value: string;
        uid: string & import("zod").BRAND<"securityScheme">;
        name: string;
        nameKey: string;
        in: "cookie" | "query" | "header";
        description?: string | undefined;
    } | {
        type: "http";
        uid: string & import("zod").BRAND<"securityScheme">;
        nameKey: string;
        scheme: "basic" | "bearer";
        bearerFormat: string;
        username: string;
        password: string;
        token: string;
        description?: string | undefined;
    } | {
        type: "openIdConnect";
        uid: string & import("zod").BRAND<"securityScheme">;
        nameKey: string;
        openIdConnectUrl: string;
        description?: string | undefined;
    } | {
        type: "oauth2";
        uid: string & import("zod").BRAND<"securityScheme">;
        nameKey: string;
        flows: {
            password?: {
                type: "password";
                username: string;
                password: string;
                token: string;
                refreshUrl: string;
                scopes: Record<string, string>;
                selectedScopes: string[];
                "x-scalar-client-id": string;
                tokenUrl: string;
                clientSecret: string;
            } | undefined;
            implicit?: {
                type: "implicit";
                token: string;
                refreshUrl: string;
                scopes: Record<string, string>;
                selectedScopes: string[];
                "x-scalar-client-id": string;
                authorizationUrl: string;
                "x-scalar-redirect-uri": string;
            } | undefined;
            clientCredentials?: {
                type: "clientCredentials";
                token: string;
                refreshUrl: string;
                scopes: Record<string, string>;
                selectedScopes: string[];
                "x-scalar-client-id": string;
                tokenUrl: string;
                clientSecret: string;
            } | undefined;
            authorizationCode?: {
                type: "authorizationCode";
                token: string;
                refreshUrl: string;
                scopes: Record<string, string>;
                selectedScopes: string[];
                "x-scalar-client-id": string;
                authorizationUrl: string;
                "x-scalar-redirect-uri": string;
                tokenUrl: string;
                clientSecret: string;
                "x-usePkce": "SHA-256" | "plain" | "no";
            } | undefined;
        };
        description?: string | undefined;
    }>;
    securitySchemeMutators: {
        add: (item: {
            type: "apiKey";
            value: string;
            uid: string & import("zod").BRAND<"securityScheme">;
            name: string;
            nameKey: string;
            in: "cookie" | "query" | "header";
            description?: string | undefined;
        } | {
            type: "http";
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            scheme: "basic" | "bearer";
            bearerFormat: string;
            username: string;
            password: string;
            token: string;
            description?: string | undefined;
        } | {
            type: "openIdConnect";
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            openIdConnectUrl: string;
            description?: string | undefined;
        } | {
            type: "oauth2";
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            flows: {
                password?: {
                    type: "password";
                    username: string;
                    password: string;
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    tokenUrl: string;
                    clientSecret: string;
                } | undefined;
                implicit?: {
                    type: "implicit";
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    authorizationUrl: string;
                    "x-scalar-redirect-uri": string;
                } | undefined;
                clientCredentials?: {
                    type: "clientCredentials";
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    tokenUrl: string;
                    clientSecret: string;
                } | undefined;
                authorizationCode?: {
                    type: "authorizationCode";
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    authorizationUrl: string;
                    "x-scalar-redirect-uri": string;
                    tokenUrl: string;
                    clientSecret: string;
                    "x-usePkce": "SHA-256" | "plain" | "no";
                } | undefined;
            };
            description?: string | undefined;
        }) => void;
        delete: (uid: (string & import("zod").BRAND<"securityScheme">) | null | undefined) => void;
        set: (item: {
            type: "apiKey";
            value: string;
            uid: string & import("zod").BRAND<"securityScheme">;
            name: string;
            nameKey: string;
            in: "cookie" | "query" | "header";
            description?: string | undefined;
        } | {
            type: "http";
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            scheme: "basic" | "bearer";
            bearerFormat: string;
            username: string;
            password: string;
            token: string;
            description?: string | undefined;
        } | {
            type: "openIdConnect";
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            openIdConnectUrl: string;
            description?: string | undefined;
        } | {
            type: "oauth2";
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            flows: {
                password?: {
                    type: "password";
                    username: string;
                    password: string;
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    tokenUrl: string;
                    clientSecret: string;
                } | undefined;
                implicit?: {
                    type: "implicit";
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    authorizationUrl: string;
                    "x-scalar-redirect-uri": string;
                } | undefined;
                clientCredentials?: {
                    type: "clientCredentials";
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    tokenUrl: string;
                    clientSecret: string;
                } | undefined;
                authorizationCode?: {
                    type: "authorizationCode";
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    authorizationUrl: string;
                    "x-scalar-redirect-uri": string;
                    tokenUrl: string;
                    clientSecret: string;
                    "x-usePkce": "SHA-256" | "plain" | "no";
                } | undefined;
            };
            description?: string | undefined;
        }) => void;
        edit: <P extends "description" | "type" | "name" | "in" | "uid" | "nameKey" | "scheme" | "bearerFormat" | "openIdConnectUrl" | "flows" | "password" | "username" | "value" | "token" | "flows.password" | "flows.implicit" | "flows.clientCredentials" | "flows.authorizationCode" | "flows.password.type" | "flows.password.password" | "flows.password.username" | "flows.password.token" | "flows.password.refreshUrl" | "flows.password.scopes" | "flows.password.selectedScopes" | "flows.password.x-scalar-client-id" | "flows.password.tokenUrl" | "flows.password.clientSecret" | `flows.password.scopes.${string}` | `flows.password.selectedScopes.${number}` | "flows.implicit.type" | "flows.implicit.token" | "flows.implicit.refreshUrl" | "flows.implicit.scopes" | "flows.implicit.selectedScopes" | "flows.implicit.x-scalar-client-id" | `flows.implicit.scopes.${string}` | `flows.implicit.selectedScopes.${number}` | "flows.implicit.authorizationUrl" | "flows.implicit.x-scalar-redirect-uri" | "flows.clientCredentials.type" | "flows.clientCredentials.token" | "flows.clientCredentials.refreshUrl" | "flows.clientCredentials.scopes" | "flows.clientCredentials.selectedScopes" | "flows.clientCredentials.x-scalar-client-id" | "flows.clientCredentials.tokenUrl" | "flows.clientCredentials.clientSecret" | `flows.clientCredentials.scopes.${string}` | `flows.clientCredentials.selectedScopes.${number}` | "flows.authorizationCode.type" | "flows.authorizationCode.token" | "flows.authorizationCode.refreshUrl" | "flows.authorizationCode.scopes" | "flows.authorizationCode.selectedScopes" | "flows.authorizationCode.x-scalar-client-id" | "flows.authorizationCode.tokenUrl" | "flows.authorizationCode.clientSecret" | `flows.authorizationCode.scopes.${string}` | `flows.authorizationCode.selectedScopes.${number}` | "flows.authorizationCode.authorizationUrl" | "flows.authorizationCode.x-scalar-redirect-uri" | "flows.authorizationCode.x-usePkce">(uid: (string & import("zod").BRAND<"securityScheme">) | null | undefined, path: P, value: (P extends "description" | "type" | "name" | "in" | "uid" | "nameKey" | "value" ? {
            type: "apiKey";
            value: string;
            uid: string & import("zod").BRAND<"securityScheme">;
            name: string;
            nameKey: string;
            in: "cookie" | "query" | "header";
            description?: string | undefined;
        }[P] : P extends `${infer K}.${infer R}` ? K extends "description" | "type" | "name" | "in" | "uid" | "nameKey" | "value" ? R extends import("@scalar/object-utils/nested").Path<{
            type: "apiKey";
            value: string;
            uid: string & import("zod").BRAND<"securityScheme">;
            name: string;
            nameKey: string;
            in: "cookie" | "query" | "header";
            description?: string | undefined;
        }[K]> ? import("@scalar/object-utils/nested").PathValue<{
            type: "apiKey";
            value: string;
            uid: string & import("zod").BRAND<"securityScheme">;
            name: string;
            nameKey: string;
            in: "cookie" | "query" | "header";
            description?: string | undefined;
        }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) | (P extends "description" | "type" | "uid" | "nameKey" | "scheme" | "bearerFormat" | "password" | "username" | "token" ? {
            type: "http";
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            scheme: "basic" | "bearer";
            bearerFormat: string;
            username: string;
            password: string;
            token: string;
            description?: string | undefined;
        }[P] : P extends `${infer K}.${infer R}` ? K extends "description" | "type" | "uid" | "nameKey" | "scheme" | "bearerFormat" | "password" | "username" | "token" ? R extends import("@scalar/object-utils/nested").Path<{
            type: "http";
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            scheme: "basic" | "bearer";
            bearerFormat: string;
            username: string;
            password: string;
            token: string;
            description?: string | undefined;
        }[K]> ? import("@scalar/object-utils/nested").PathValue<{
            type: "http";
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            scheme: "basic" | "bearer";
            bearerFormat: string;
            username: string;
            password: string;
            token: string;
            description?: string | undefined;
        }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) | (P extends "description" | "type" | "uid" | "nameKey" | "openIdConnectUrl" ? {
            type: "openIdConnect";
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            openIdConnectUrl: string;
            description?: string | undefined;
        }[P] : P extends `${infer K}.${infer R}` ? K extends "description" | "type" | "uid" | "nameKey" | "openIdConnectUrl" ? R extends import("@scalar/object-utils/nested").Path<{
            type: "openIdConnect";
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            openIdConnectUrl: string;
            description?: string | undefined;
        }[K]> ? import("@scalar/object-utils/nested").PathValue<{
            type: "openIdConnect";
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            openIdConnectUrl: string;
            description?: string | undefined;
        }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) | (P extends "description" | "type" | "uid" | "nameKey" | "flows" ? {
            type: "oauth2";
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            flows: {
                password?: {
                    type: "password";
                    username: string;
                    password: string;
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    tokenUrl: string;
                    clientSecret: string;
                } | undefined;
                implicit?: {
                    type: "implicit";
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    authorizationUrl: string;
                    "x-scalar-redirect-uri": string;
                } | undefined;
                clientCredentials?: {
                    type: "clientCredentials";
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    tokenUrl: string;
                    clientSecret: string;
                } | undefined;
                authorizationCode?: {
                    type: "authorizationCode";
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    authorizationUrl: string;
                    "x-scalar-redirect-uri": string;
                    tokenUrl: string;
                    clientSecret: string;
                    "x-usePkce": "SHA-256" | "plain" | "no";
                } | undefined;
            };
            description?: string | undefined;
        }[P] : P extends `${infer K}.${infer R}` ? K extends "description" | "type" | "uid" | "nameKey" | "flows" ? R extends import("@scalar/object-utils/nested").Path<{
            type: "oauth2";
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            flows: {
                password?: {
                    type: "password";
                    username: string;
                    password: string;
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    tokenUrl: string;
                    clientSecret: string;
                } | undefined;
                implicit?: {
                    type: "implicit";
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    authorizationUrl: string;
                    "x-scalar-redirect-uri": string;
                } | undefined;
                clientCredentials?: {
                    type: "clientCredentials";
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    tokenUrl: string;
                    clientSecret: string;
                } | undefined;
                authorizationCode?: {
                    type: "authorizationCode";
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    authorizationUrl: string;
                    "x-scalar-redirect-uri": string;
                    tokenUrl: string;
                    clientSecret: string;
                    "x-usePkce": "SHA-256" | "plain" | "no";
                } | undefined;
            };
            description?: string | undefined;
        }[K]> ? import("@scalar/object-utils/nested").PathValue<{
            type: "oauth2";
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            flows: {
                password?: {
                    type: "password";
                    username: string;
                    password: string;
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    tokenUrl: string;
                    clientSecret: string;
                } | undefined;
                implicit?: {
                    type: "implicit";
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    authorizationUrl: string;
                    "x-scalar-redirect-uri": string;
                } | undefined;
                clientCredentials?: {
                    type: "clientCredentials";
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    tokenUrl: string;
                    clientSecret: string;
                } | undefined;
                authorizationCode?: {
                    type: "authorizationCode";
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    authorizationUrl: string;
                    "x-scalar-redirect-uri": string;
                    tokenUrl: string;
                    clientSecret: string;
                    "x-usePkce": "SHA-256" | "plain" | "no";
                } | undefined;
            };
            description?: string | undefined;
        }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never)) => void;
        untrackedEdit: <P extends "description" | "type" | "name" | "in" | "uid" | "nameKey" | "scheme" | "bearerFormat" | "openIdConnectUrl" | "flows" | "password" | "username" | "value" | "token" | "flows.password" | "flows.implicit" | "flows.clientCredentials" | "flows.authorizationCode" | "flows.password.type" | "flows.password.password" | "flows.password.username" | "flows.password.token" | "flows.password.refreshUrl" | "flows.password.scopes" | "flows.password.selectedScopes" | "flows.password.x-scalar-client-id" | "flows.password.tokenUrl" | "flows.password.clientSecret" | `flows.password.scopes.${string}` | `flows.password.selectedScopes.${number}` | "flows.implicit.type" | "flows.implicit.token" | "flows.implicit.refreshUrl" | "flows.implicit.scopes" | "flows.implicit.selectedScopes" | "flows.implicit.x-scalar-client-id" | `flows.implicit.scopes.${string}` | `flows.implicit.selectedScopes.${number}` | "flows.implicit.authorizationUrl" | "flows.implicit.x-scalar-redirect-uri" | "flows.clientCredentials.type" | "flows.clientCredentials.token" | "flows.clientCredentials.refreshUrl" | "flows.clientCredentials.scopes" | "flows.clientCredentials.selectedScopes" | "flows.clientCredentials.x-scalar-client-id" | "flows.clientCredentials.tokenUrl" | "flows.clientCredentials.clientSecret" | `flows.clientCredentials.scopes.${string}` | `flows.clientCredentials.selectedScopes.${number}` | "flows.authorizationCode.type" | "flows.authorizationCode.token" | "flows.authorizationCode.refreshUrl" | "flows.authorizationCode.scopes" | "flows.authorizationCode.selectedScopes" | "flows.authorizationCode.x-scalar-client-id" | "flows.authorizationCode.tokenUrl" | "flows.authorizationCode.clientSecret" | `flows.authorizationCode.scopes.${string}` | `flows.authorizationCode.selectedScopes.${number}` | "flows.authorizationCode.authorizationUrl" | "flows.authorizationCode.x-scalar-redirect-uri" | "flows.authorizationCode.x-usePkce">(uid: string & import("zod").BRAND<"securityScheme">, path: P, value: (P extends "description" | "type" | "name" | "in" | "uid" | "nameKey" | "value" ? {
            type: "apiKey";
            value: string;
            uid: string & import("zod").BRAND<"securityScheme">;
            name: string;
            nameKey: string;
            in: "cookie" | "query" | "header";
            description?: string | undefined;
        }[P] : P extends `${infer K}.${infer R}` ? K extends "description" | "type" | "name" | "in" | "uid" | "nameKey" | "value" ? R extends import("@scalar/object-utils/nested").Path<{
            type: "apiKey";
            value: string;
            uid: string & import("zod").BRAND<"securityScheme">;
            name: string;
            nameKey: string;
            in: "cookie" | "query" | "header";
            description?: string | undefined;
        }[K]> ? import("@scalar/object-utils/nested").PathValue<{
            type: "apiKey";
            value: string;
            uid: string & import("zod").BRAND<"securityScheme">;
            name: string;
            nameKey: string;
            in: "cookie" | "query" | "header";
            description?: string | undefined;
        }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) | (P extends "description" | "type" | "uid" | "nameKey" | "scheme" | "bearerFormat" | "password" | "username" | "token" ? {
            type: "http";
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            scheme: "basic" | "bearer";
            bearerFormat: string;
            username: string;
            password: string;
            token: string;
            description?: string | undefined;
        }[P] : P extends `${infer K}.${infer R}` ? K extends "description" | "type" | "uid" | "nameKey" | "scheme" | "bearerFormat" | "password" | "username" | "token" ? R extends import("@scalar/object-utils/nested").Path<{
            type: "http";
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            scheme: "basic" | "bearer";
            bearerFormat: string;
            username: string;
            password: string;
            token: string;
            description?: string | undefined;
        }[K]> ? import("@scalar/object-utils/nested").PathValue<{
            type: "http";
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            scheme: "basic" | "bearer";
            bearerFormat: string;
            username: string;
            password: string;
            token: string;
            description?: string | undefined;
        }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) | (P extends "description" | "type" | "uid" | "nameKey" | "openIdConnectUrl" ? {
            type: "openIdConnect";
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            openIdConnectUrl: string;
            description?: string | undefined;
        }[P] : P extends `${infer K}.${infer R}` ? K extends "description" | "type" | "uid" | "nameKey" | "openIdConnectUrl" ? R extends import("@scalar/object-utils/nested").Path<{
            type: "openIdConnect";
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            openIdConnectUrl: string;
            description?: string | undefined;
        }[K]> ? import("@scalar/object-utils/nested").PathValue<{
            type: "openIdConnect";
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            openIdConnectUrl: string;
            description?: string | undefined;
        }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) | (P extends "description" | "type" | "uid" | "nameKey" | "flows" ? {
            type: "oauth2";
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            flows: {
                password?: {
                    type: "password";
                    username: string;
                    password: string;
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    tokenUrl: string;
                    clientSecret: string;
                } | undefined;
                implicit?: {
                    type: "implicit";
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    authorizationUrl: string;
                    "x-scalar-redirect-uri": string;
                } | undefined;
                clientCredentials?: {
                    type: "clientCredentials";
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    tokenUrl: string;
                    clientSecret: string;
                } | undefined;
                authorizationCode?: {
                    type: "authorizationCode";
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    authorizationUrl: string;
                    "x-scalar-redirect-uri": string;
                    tokenUrl: string;
                    clientSecret: string;
                    "x-usePkce": "SHA-256" | "plain" | "no";
                } | undefined;
            };
            description?: string | undefined;
        }[P] : P extends `${infer K}.${infer R}` ? K extends "description" | "type" | "uid" | "nameKey" | "flows" ? R extends import("@scalar/object-utils/nested").Path<{
            type: "oauth2";
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            flows: {
                password?: {
                    type: "password";
                    username: string;
                    password: string;
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    tokenUrl: string;
                    clientSecret: string;
                } | undefined;
                implicit?: {
                    type: "implicit";
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    authorizationUrl: string;
                    "x-scalar-redirect-uri": string;
                } | undefined;
                clientCredentials?: {
                    type: "clientCredentials";
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    tokenUrl: string;
                    clientSecret: string;
                } | undefined;
                authorizationCode?: {
                    type: "authorizationCode";
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    authorizationUrl: string;
                    "x-scalar-redirect-uri": string;
                    tokenUrl: string;
                    clientSecret: string;
                    "x-usePkce": "SHA-256" | "plain" | "no";
                } | undefined;
            };
            description?: string | undefined;
        }[K]> ? import("@scalar/object-utils/nested").PathValue<{
            type: "oauth2";
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            flows: {
                password?: {
                    type: "password";
                    username: string;
                    password: string;
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    tokenUrl: string;
                    clientSecret: string;
                } | undefined;
                implicit?: {
                    type: "implicit";
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    authorizationUrl: string;
                    "x-scalar-redirect-uri": string;
                } | undefined;
                clientCredentials?: {
                    type: "clientCredentials";
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    tokenUrl: string;
                    clientSecret: string;
                } | undefined;
                authorizationCode?: {
                    type: "authorizationCode";
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    authorizationUrl: string;
                    "x-scalar-redirect-uri": string;
                    tokenUrl: string;
                    clientSecret: string;
                    "x-usePkce": "SHA-256" | "plain" | "no";
                } | undefined;
            };
            description?: string | undefined;
        }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never)) => void;
        undo: (uid: string & import("zod").BRAND<"securityScheme">) => void;
        redo: (uid: string & import("zod").BRAND<"securityScheme">) => void;
        reset: () => void;
    };
};
/** Extended mutators and data for security schemas */
export declare function extendedSecurityDataFactory({ securitySchemeMutators, collectionMutators, collections, requests, requestMutators, }: StoreContext): {
    addSecurityScheme: (payload: SecuritySchemePayload, collectionUid: Collection["uid"]) => {
        type: "apiKey";
        value: string;
        uid: string & import("zod").BRAND<"securityScheme">;
        name: string;
        nameKey: string;
        in: "cookie" | "query" | "header";
        description?: string | undefined;
    } | {
        type: "http";
        uid: string & import("zod").BRAND<"securityScheme">;
        nameKey: string;
        scheme: "basic" | "bearer";
        bearerFormat: string;
        username: string;
        password: string;
        token: string;
        description?: string | undefined;
    } | {
        type: "openIdConnect";
        uid: string & import("zod").BRAND<"securityScheme">;
        nameKey: string;
        openIdConnectUrl: string;
        description?: string | undefined;
    } | {
        type: "oauth2";
        uid: string & import("zod").BRAND<"securityScheme">;
        nameKey: string;
        flows: {
            password?: {
                type: "password";
                username: string;
                password: string;
                token: string;
                refreshUrl: string;
                scopes: Record<string, string>;
                selectedScopes: string[];
                "x-scalar-client-id": string;
                tokenUrl: string;
                clientSecret: string;
            } | undefined;
            implicit?: {
                type: "implicit";
                token: string;
                refreshUrl: string;
                scopes: Record<string, string>;
                selectedScopes: string[];
                "x-scalar-client-id": string;
                authorizationUrl: string;
                "x-scalar-redirect-uri": string;
            } | undefined;
            clientCredentials?: {
                type: "clientCredentials";
                token: string;
                refreshUrl: string;
                scopes: Record<string, string>;
                selectedScopes: string[];
                "x-scalar-client-id": string;
                tokenUrl: string;
                clientSecret: string;
            } | undefined;
            authorizationCode?: {
                type: "authorizationCode";
                token: string;
                refreshUrl: string;
                scopes: Record<string, string>;
                selectedScopes: string[];
                "x-scalar-client-id": string;
                authorizationUrl: string;
                "x-scalar-redirect-uri": string;
                tokenUrl: string;
                clientSecret: string;
                "x-usePkce": "SHA-256" | "plain" | "no";
            } | undefined;
        };
        description?: string | undefined;
    };
    deleteSecurityScheme: (schemeUid: SecurityScheme["uid"]) => void;
};
//# sourceMappingURL=security-schemes.d.ts.map