/**
 * Platform Variants
 */
export declare const platformVariants: readonly ["mac", "windows", "linux"];
/**
 * Add support for `desktop` and platform modifiers
 *
 * @example <div class="desktop:rounded-lg">...</div>
 * @example <div class="mac:hidden">...</div>
 *
 * Modified from `@todesktop/tailwind-variants`
 * @see https://github.com/todesktop/tailwind-variants
 */
export declare const desktopVariants: {
    handler: import("tailwindcss/types/config").PluginCreator;
    config?: Partial<import("tailwindcss/types/config").Config>;
};
//# sourceMappingURL=desktop-variants.d.ts.map