import type { ErrorResponse } from '../../../../libs/errors';
import type { Operation, RequestExample, SecurityScheme, Server } from '@scalar/oas-utils/entities/spec';
import { type ClientId, type TargetId } from '@scalar/snippetz';
/**
 * Returns a code example for given operation
 */
export declare const getSnippet: <T extends TargetId>(target: T | "javascript", client: ClientId<T>, { operation, example, server, securitySchemes, }: {
    operation?: Operation | undefined;
    example?: RequestExample | undefined;
    server?: Server | undefined;
    securitySchemes?: SecurityScheme[];
}) => ErrorResponse<string>;
//# sourceMappingURL=get-snippet.d.ts.map