import { defineComponent as b, openBlock as s, createElementBlock as V, Fragment as U, createVNode as a, unref as r, withCtx as o, mergeProps as m, createTextVNode as d, createElementVNode as $, createBlock as k, createCommentVNode as p } from "vue";
import { useWorkspace as C } from "../../../../store/store.js";
import { useLoadingState as P, ScalarButton as z } from "@scalar/components";
import { pkceOptions as L } from "@scalar/oas-utils/entities/spec";
import { useToasts as R } from "@scalar/use-toasts";
import B from "./OAuthScopesInput.vue.js";
import w from "./RequestAuthDataTableInput.vue.js";
import u from "../../../../components/DataTable/DataTableRow.vue.js";
import { authorizeOauth2 as F } from "../../libs/oauth2.js";
const I = { class: "h-8 flex items-center justify-self-end" }, A = { class: "h-8 flex items-center justify-end border-t-1/2 w-full" }, W = /* @__PURE__ */ b({
  __name: "OAuth2",
  props: {
    collection: {},
    environment: {},
    envVariables: {},
    flow: {},
    scheme: {},
    server: {},
    workspace: {}
  },
  setup(f) {
    const y = P(), { toast: g } = R(), { securitySchemeMutators: S } = C(), n = (l, e) => S.edit(f.scheme.uid, l, e), T = async () => {
      var t, v;
      if (y.isLoading || !((t = f.collection) != null && t.uid)) return;
      if (y.startLoading(), !f.server) {
        g("No server selected", "error");
        return;
      }
      const [l, e] = await F(
        f.flow,
        f.server,
        (v = f.workspace) == null ? void 0 : v.proxyUrl
      ).finally(() => y.stopLoading());
      e ? n(`flows.${f.flow.type}.token`, e) : (console.error(l), g((l == null ? void 0 : l.message) ?? "Failed to authorize", "error"));
    }, i = {
      environment: f.environment,
      envVariables: f.envVariables,
      workspace: f.workspace
    };
    return (l, e) => (s(), V(U, null, [
      l.flow.token ? (s(), V(U, { key: 0 }, [
        a(r(u), null, {
          default: o(() => [
            a(w, m(i, {
              class: "border-r-transparent",
              modelValue: l.flow.token,
              placeholder: "QUxMIFlPVVIgQkFTRSBBUkUgQkVMT05HIFRPIFVT",
              type: "password",
              "onUpdate:modelValue": e[0] || (e[0] = (t) => n(`flows.${l.flow.type}.token`, t))
            }), {
              default: o(() => e[10] || (e[10] = [
                d(" Access Token ")
              ])),
              _: 1
            }, 16, ["modelValue"])
          ]),
          _: 1
        }),
        a(r(u), { class: "min-w-full" }, {
          default: o(() => [
            $("div", I, [
              a(r(z), {
                class: "p-0 py-0.5 px-2 mr-1",
                loading: r(y),
                size: "sm",
                variant: "outlined",
                onClick: e[1] || (e[1] = (t) => n(`flows.${l.flow.type}.token`, ""))
              }, {
                default: o(() => e[11] || (e[11] = [
                  d(" Clear ")
                ])),
                _: 1
              }, 8, ["loading"])
            ])
          ]),
          _: 1
        })
      ], 64)) : (s(), V(U, { key: 1 }, [
        a(r(u), null, {
          default: o(() => [
            "authorizationUrl" in l.flow ? (s(), k(w, m({ key: 0 }, i, {
              modelValue: l.flow.authorizationUrl,
              placeholder: "https://galaxy.scalar.com/authorize",
              "onUpdate:modelValue": e[2] || (e[2] = (t) => n(`flows.${l.flow.type}.authorizationUrl`, t))
            }), {
              default: o(() => e[12] || (e[12] = [
                d(" Auth URL ")
              ])),
              _: 1
            }, 16, ["modelValue"])) : p("", !0),
            "tokenUrl" in l.flow ? (s(), k(w, m({ key: 1 }, i, {
              modelValue: l.flow.tokenUrl,
              placeholder: "https://galaxy.scalar.com/token",
              "onUpdate:modelValue": e[3] || (e[3] = (t) => n(`flows.${l.flow.type}.tokenUrl`, t))
            }), {
              default: o(() => e[13] || (e[13] = [
                d(" Token URL ")
              ])),
              _: 1
            }, 16, ["modelValue"])) : p("", !0)
          ]),
          _: 1
        }),
        "x-scalar-redirect-uri" in l.flow ? (s(), k(r(u), { key: 0 }, {
          default: o(() => [
            a(w, m(i, {
              modelValue: l.flow["x-scalar-redirect-uri"],
              placeholder: "https://galaxy.scalar.com/callback",
              "onUpdate:modelValue": e[4] || (e[4] = (t) => n(`flows.${l.flow.type}.x-scalar-redirect-uri`, t))
            }), {
              default: o(() => e[14] || (e[14] = [
                d(" Redirect URL ")
              ])),
              _: 1
            }, 16, ["modelValue"])
          ]),
          _: 1
        })) : p("", !0),
        l.flow.type === "password" ? (s(), V(U, { key: 1 }, [
          a(r(u), null, {
            default: o(() => [
              a(w, m(i, {
                class: "text-c-2",
                modelValue: l.flow.username,
                placeholder: "janedoe",
                "onUpdate:modelValue": e[5] || (e[5] = (t) => n(`flows.${l.flow.type}.username`, t))
              }), {
                default: o(() => e[15] || (e[15] = [
                  d(" Username ")
                ])),
                _: 1
              }, 16, ["modelValue"])
            ]),
            _: 1
          }),
          a(r(u), null, {
            default: o(() => [
              a(w, m(i, {
                modelValue: l.flow.password,
                placeholder: "********",
                type: "password",
                "onUpdate:modelValue": e[6] || (e[6] = (t) => n(`flows.${l.flow.type}.password`, t))
              }), {
                default: o(() => e[16] || (e[16] = [
                  d(" Password ")
                ])),
                _: 1
              }, 16, ["modelValue"])
            ]),
            _: 1
          })
        ], 64)) : p("", !0),
        a(r(u), null, {
          default: o(() => [
            a(w, m(i, {
              modelValue: l.flow["x-scalar-client-id"],
              placeholder: "12345",
              "onUpdate:modelValue": e[7] || (e[7] = (t) => n(`flows.${l.flow.type}.x-scalar-client-id`, t))
            }), {
              default: o(() => e[17] || (e[17] = [
                d(" Client ID ")
              ])),
              _: 1
            }, 16, ["modelValue"])
          ]),
          _: 1
        }),
        "clientSecret" in l.flow ? (s(), k(r(u), { key: 2 }, {
          default: o(() => [
            a(w, m(i, {
              modelValue: l.flow.clientSecret,
              placeholder: "XYZ123",
              type: "password",
              "onUpdate:modelValue": e[8] || (e[8] = (t) => n(`flows.${l.flow.type}.clientSecret`, t))
            }), {
              default: o(() => e[18] || (e[18] = [
                d(" Client Secret ")
              ])),
              _: 1
            }, 16, ["modelValue"])
          ]),
          _: 1
        })) : p("", !0),
        "x-usePkce" in l.flow ? (s(), k(r(u), { key: 3 }, {
          default: o(() => [
            a(w, m(i, {
              enum: r(L),
              modelValue: l.flow["x-usePkce"],
              readOnly: "",
              "onUpdate:modelValue": e[9] || (e[9] = (t) => n(
                `flows.${l.flow.type}.x-usePkce`,
                t
              ))
            }), {
              default: o(() => e[19] || (e[19] = [
                d(" Use PKCE ")
              ])),
              _: 1
            }, 16, ["enum", "modelValue"])
          ]),
          _: 1
        })) : p("", !0),
        Object.keys(l.flow.scopes ?? {}).length ? (s(), k(r(u), { key: 4 }, {
          default: o(() => [
            a(B, {
              flow: l.flow,
              updateScheme: n
            }, null, 8, ["flow"])
          ]),
          _: 1
        })) : p("", !0)
      ], 64)),
      l.flow.token ? p("", !0) : (s(), k(r(u), {
        key: 2,
        class: "min-w-full"
      }, {
        default: o(() => [
          $("div", A, [
            a(r(z), {
              class: "p-0 py-0.5 px-2 mr-1",
              loading: r(y),
              size: "sm",
              variant: "outlined",
              onClick: T
            }, {
              default: o(() => e[20] || (e[20] = [
                d(" Authorize ")
              ])),
              _: 1
            }, 8, ["loading"])
          ])
        ]),
        _: 1
      }))
    ], 64));
  }
});
export {
  W as default
};
