import { type DraggableProps, type DraggingItem, type HoveredItem } from '@scalar/draggable';
import type { SidebarMenuItem } from '../../views/Request/types';
type __VLS_Props = {
    /**
     * Toggle dragging on and off
     *
     * @default false
     */
    isDraggable?: boolean;
    /**
     * Prevents items from being hovered and dropped into
     *
     * @default false
     */
    isDroppable?: DraggableProps['isDroppable'];
    /** Both indicate the level and provide a way to traverse upwards */
    parentUids: string[];
    /** uid of a Collection, Tag, Request or RequestExample */
    uid: string;
    /** To keep track of the menu being open */
    menuItem: SidebarMenuItem;
};
declare function __VLS_template(): {
    attrs: Partial<{}>;
    slots: Readonly<{
        leftIcon(): void;
    }> & {
        leftIcon(): void;
    };
    refs: {
        draggableRef: ({
            $: import("vue").ComponentInternalInstance;
            $data: {};
            $props: {
                readonly ceiling?: number;
                readonly floor?: number;
                readonly isDraggable?: boolean;
                readonly isDroppable?: boolean | ((draggingItem: DraggingItem, hoveredItem: HoveredItem) => boolean);
                readonly parentIds: string[];
                readonly id: string;
                readonly onOnDragEnd?: (draggingItem: DraggingItem, hoveredItem: HoveredItem) => any;
                readonly onOnDragStart?: (draggingItem: DraggingItem) => any;
            } & import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps;
            $attrs: {
                [x: string]: unknown;
            };
            $refs: {
                [x: string]: unknown;
            };
            $slots: Readonly<{
                [name: string]: import("vue").Slot<any> | undefined;
            }>;
            $root: import("vue").ComponentPublicInstance | null;
            $parent: import("vue").ComponentPublicInstance | null;
            $host: Element | null;
            $emit: ((event: "onDragEnd", draggingItem: DraggingItem, hoveredItem: HoveredItem) => void) & ((event: "onDragStart", draggingItem: DraggingItem) => void);
            $el: HTMLDivElement;
            $options: import("vue").ComponentOptionsBase<Readonly<DraggableProps> & Readonly<{
                onOnDragEnd?: (draggingItem: DraggingItem, hoveredItem: HoveredItem) => any;
                onOnDragStart?: (draggingItem: DraggingItem) => any;
            }>, {
                draggingItem: import("vue").Ref<{
                    id: string;
                    parentId: string | null;
                } | null, DraggingItem | {
                    id: string;
                    parentId: string | null;
                } | null>;
                hoveredItem: import("vue").Ref<{
                    id: string;
                    parentId: string | null;
                    offset: number;
                } | null, HoveredItem | {
                    id: string;
                    parentId: string | null;
                    offset: number;
                } | null>;
            }, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {
                onDragEnd: (draggingItem: DraggingItem, hoveredItem: HoveredItem) => any;
                onDragStart: (draggingItem: DraggingItem) => any;
            }, string, {}, {}, string, {}, import("vue").GlobalComponents, import("vue").GlobalDirectives, string, import("vue").ComponentProvideOptions> & {
                beforeCreate?: (() => void) | (() => void)[];
                created?: (() => void) | (() => void)[];
                beforeMount?: (() => void) | (() => void)[];
                mounted?: (() => void) | (() => void)[];
                beforeUpdate?: (() => void) | (() => void)[];
                updated?: (() => void) | (() => void)[];
                activated?: (() => void) | (() => void)[];
                deactivated?: (() => void) | (() => void)[];
                beforeDestroy?: (() => void) | (() => void)[];
                beforeUnmount?: (() => void) | (() => void)[];
                destroyed?: (() => void) | (() => void)[];
                unmounted?: (() => void) | (() => void)[];
                renderTracked?: ((e: import("vue").DebuggerEvent) => void) | ((e: import("vue").DebuggerEvent) => void)[];
                renderTriggered?: ((e: import("vue").DebuggerEvent) => void) | ((e: import("vue").DebuggerEvent) => void)[];
                errorCaptured?: ((err: unknown, instance: import("vue").ComponentPublicInstance | null, info: string) => boolean | void) | ((err: unknown, instance: import("vue").ComponentPublicInstance | null, info: string) => boolean | void)[];
            };
            $forceUpdate: () => void;
            $nextTick: typeof import("vue").nextTick;
            $watch<T extends string | ((...args: any) => any)>(source: T, cb: T extends (...args: any) => infer R ? (...args: [R, R, import("@vue/reactivity").OnCleanup]) => any : (...args: [any, any, import("@vue/reactivity").OnCleanup]) => any, options?: import("vue").WatchOptions): import("vue").WatchStopHandle;
        } & Readonly<{}> & Omit<Readonly<DraggableProps> & Readonly<{
            onOnDragEnd?: (draggingItem: DraggingItem, hoveredItem: HoveredItem) => any;
            onOnDragStart?: (draggingItem: DraggingItem) => any;
        }>, "draggingItem" | "hoveredItem"> & import("vue").ShallowUnwrapRef<{
            draggingItem: import("vue").Ref<{
                id: string;
                parentId: string | null;
            } | null, DraggingItem | {
                id: string;
                parentId: string | null;
            } | null>;
            hoveredItem: import("vue").Ref<{
                id: string;
                parentId: string | null;
                offset: number;
            } | null, HoveredItem | {
                id: string;
                parentId: string | null;
                offset: number;
            } | null>;
        }> & {} & import("vue").ComponentCustomProperties & {} & {
            $slots: {
                default?(_: {}): any;
            };
        }) | null;
    };
    rootEl: any;
};
type __VLS_TemplateResult = ReturnType<typeof __VLS_template>;
declare const __VLS_component: import("vue").DefineComponent<__VLS_Props, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {
    onDragEnd: (draggingItem: DraggingItem, hoveredItem: HoveredItem) => any;
    newTab: (name: string, uid: string) => any;
    openMenu: (menuItem: SidebarMenuItem) => any;
}, string, import("vue").PublicProps, Readonly<__VLS_Props> & Readonly<{
    onOnDragEnd?: (draggingItem: DraggingItem, hoveredItem: HoveredItem) => any;
    onNewTab?: (name: string, uid: string) => any;
    onOpenMenu?: (menuItem: SidebarMenuItem) => any;
}>, {}, {}, {}, {}, string, import("vue").ComponentProvideOptions, false, {}, any>;
declare const _default: __VLS_WithTemplateSlots<typeof __VLS_component, __VLS_TemplateResult["slots"]>;
export default _default;
type __VLS_WithTemplateSlots<T, S> = T & {
    new (): {
        $slots: S;
    };
};
//# sourceMappingURL=RequestSidebarItem.vue.d.ts.map